/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractGauge;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.MicrometerLongGauge;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterSharedState;
import java.util.function.Consumer;

public final class MicrometerDoubleGauge
extends AbstractGauge {
    private MicrometerDoubleGauge(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public static DoubleGaugeBuilder builder(MeterSharedState meterSharedState, String name) {
        return new DoubleBuilder(meterSharedState, name);
    }

    private static class DoubleBuilder
    extends AbstractInstrumentBuilder<DoubleBuilder>
    implements DoubleGaugeBuilder {
        private DoubleBuilder(MeterSharedState meterSharedState, String name) {
            super(meterSharedState, name);
        }

        @Override
        public DoubleBuilder self() {
            return this;
        }

        public LongGaugeBuilder ofLongs() {
            return MicrometerLongGauge.builder(this.meterSharedState, this.name, this.description, this.unit);
        }

        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            final MicrometerDoubleGauge instrument = new MicrometerDoubleGauge(this.createInstrumentState());
            return instrument.registerDoubleCallback(callback, new ObservableDoubleMeasurement(){

                public void record(double value) {
                    this.record(value, Attributes.empty());
                }

                public void record(double value, Attributes attributes) {
                    instrument.record(value, attributes);
                }
            });
        }
    }
}

