/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractUpDownCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.MicrometerDoubleUpDownCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterSharedState;
import java.util.function.Consumer;

public final class MicrometerLongUpDownCounter
extends AbstractUpDownCounter
implements LongUpDownCounter {
    private MicrometerLongUpDownCounter(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public void add(long value) {
        this.add(Attributes.empty(), value);
    }

    public void add(long value, Attributes attributes) {
        this.add(attributes, value);
    }

    public void add(long value, Attributes attributes, Context context) {
        this.add(attributes, value);
    }

    public static LongUpDownCounterBuilder builder(MeterSharedState meterSharedState, String name) {
        return new Builder(meterSharedState, name);
    }

    private static class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongUpDownCounterBuilder {
        private Builder(MeterSharedState meterSharedState, String name) {
            super(meterSharedState, name);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public DoubleUpDownCounterBuilder ofDoubles() {
            return MicrometerDoubleUpDownCounter.builder(this.meterSharedState, this.name, this.description, this.unit);
        }

        public MicrometerLongUpDownCounter build() {
            return new MicrometerLongUpDownCounter(this.createInstrumentState());
        }

        public ObservableLongUpDownCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            final MicrometerLongUpDownCounter instrument = this.build();
            return instrument.registerLongCallback(callback, new ObservableLongMeasurement(){

                public void record(long value) {
                    instrument.record(value, Attributes.empty());
                }

                public void record(long value, Attributes attributes) {
                    instrument.record(value, attributes);
                }
            });
        }
    }
}

