/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.MicrometerDoubleCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterSharedState;
import java.util.function.Consumer;

public final class MicrometerLongCounter
extends AbstractCounter
implements LongCounter {
    private MicrometerLongCounter(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public void add(long value) {
        if (value > 0L) {
            this.counter(Attributes.empty()).increment((double)value);
        }
    }

    public void add(long value, Attributes attributes) {
        if (value > 0L) {
            this.counter(attributes).increment((double)value);
        }
    }

    public void add(long value, Attributes attributes, Context context) {
        if (value > 0L) {
            this.counter(attributes).increment((double)value);
        }
    }

    public static LongCounterBuilder builder(MeterSharedState meterSharedState, String name) {
        return new Builder(meterSharedState, name);
    }

    private static class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongCounterBuilder {
        private Builder(MeterSharedState meterSharedState, String name) {
            super(meterSharedState, name);
        }

        @Override
        public Builder self() {
            return this;
        }

        public DoubleCounterBuilder ofDoubles() {
            return MicrometerDoubleCounter.builder(this.meterSharedState, this.name, this.description, this.unit);
        }

        public MicrometerLongCounter build() {
            return new MicrometerLongCounter(this.createInstrumentState());
        }

        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            final MicrometerLongCounter instrument = this.build();
            return instrument.registerLongCallback(callback, new ObservableLongMeasurement(){

                public void record(long value) {
                    this.record(value, Attributes.empty());
                }

                public void record(long value, Attributes attributes) {
                    instrument.record(value, attributes);
                }
            });
        }
    }
}

