/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterSharedState;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class MicrometerDoubleCounter
extends AbstractCounter
implements DoubleCounter {
    private MicrometerDoubleCounter(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public void add(double value) {
        if (value >= 0.0) {
            this.counter(Attributes.empty()).increment(value);
        }
    }

    public void add(double value, Attributes attributes) {
        if (value >= 0.0) {
            this.counter(attributes).increment(value);
        }
    }

    public void add(double value, Attributes attributes, Context context) {
        if (value >= 0.0) {
            this.counter(attributes).increment(value);
        }
    }

    public static DoubleCounterBuilder builder(MeterSharedState meterSharedState, String name, @Nullable String description, @Nullable String unit) {
        return new Builder(meterSharedState, name, description, unit);
    }

    private static class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements DoubleCounterBuilder {
        private Builder(MeterSharedState meterSharedState, String name, @Nullable String description, @Nullable String unit) {
            super(meterSharedState, name, description, unit);
        }

        @Override
        public Builder self() {
            return this;
        }

        public MicrometerDoubleCounter build() {
            return new MicrometerDoubleCounter(this.createInstrumentState());
        }

        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            final MicrometerDoubleCounter instrument = this.build();
            return instrument.registerDoubleCallback(callback, new ObservableDoubleMeasurement(){

                public void record(double value) {
                    this.record(value, Attributes.empty());
                }

                public void record(double value, Attributes attributes) {
                    instrument.record(value, attributes);
                }
            });
        }
    }
}

