/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.micrometer.core.instrument.Gauge;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrument;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AtomicDoubleCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class AbstractUpDownCounter
extends AbstractInstrument {
    private final Map<Attributes, AtomicDoubleCounter> counterMap = new ConcurrentHashMap<Attributes, AtomicDoubleCounter>();

    protected AbstractUpDownCounter(InstrumentState instrumentState) {
        super(instrumentState);
    }

    protected final void add(Attributes attributes, double value) {
        this.counterMap.computeIfAbsent(this.attributesOrEmpty(attributes), this::createCounter).increment(value);
    }

    protected final void record(double value, Attributes attributes) {
        this.counterMap.computeIfAbsent(this.attributesOrEmpty(attributes), this::createCounter).set(value);
    }

    private AtomicDoubleCounter createCounter(Attributes attributes) {
        AtomicDoubleCounter counter = new AtomicDoubleCounter();
        Gauge.builder((String)this.name(), (Object)counter, AtomicDoubleCounter::current).tags(this.attributesToTags(attributes)).description(this.description()).baseUnit(this.unit()).register(this.meterRegistry());
        return counter;
    }
}

