/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.state;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.util.StringUtils;
import io.opentelemetry.contrib.metrics.micrometer.CallbackRegistration;
import io.opentelemetry.contrib.metrics.micrometer.internal.Constants;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterProviderSharedState;
import javax.annotation.Nullable;

public final class MeterSharedState {
    private final MeterProviderSharedState providerSharedState;
    private final Tag instrumentationScopeNameTag;
    private final Tag instrumentationScopeVersionTag;
    @Nullable
    private final String schemaUrl;

    public MeterSharedState(MeterProviderSharedState providerSharedState, String instrumentationScopeName, @Nullable String instrumentationScopeVersion, @Nullable String schemaUrl) {
        this.providerSharedState = providerSharedState;
        this.instrumentationScopeNameTag = Tag.of((String)"otel.instrumentation.name", (String)instrumentationScopeName);
        this.instrumentationScopeVersionTag = StringUtils.isNotBlank((String)instrumentationScopeVersion) ? Tag.of((String)"otel.instrumentation.version", (String)instrumentationScopeVersion) : Constants.UNKNOWN_INSTRUMENTATION_VERSION_TAG;
        this.schemaUrl = schemaUrl;
    }

    public MeterRegistry meterRegistry() {
        return this.providerSharedState.meterRegistry();
    }

    public Tag instrumentationScopeNameTag() {
        return this.instrumentationScopeNameTag;
    }

    public Tag instrumentationScopeVersionTag() {
        return this.instrumentationScopeVersionTag;
    }

    @Nullable
    public String schemaUrl() {
        return this.schemaUrl;
    }

    public CallbackRegistration registerCallback(Runnable callback) {
        return this.providerSharedState.registerCallback(callback);
    }
}

