/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.contrib.metrics.micrometer.MicrometerMeter;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterProviderSharedState;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterSharedState;
import javax.annotation.Nullable;

final class MicrometerMeterBuilder
implements MeterBuilder {
    private final MeterProviderSharedState meterProviderSharedState;
    private final String instrumentationScopeName;
    @Nullable
    private String instrumentationScopeVersion;
    @Nullable
    private String schemaUrl;

    MicrometerMeterBuilder(MeterProviderSharedState meterProviderSharedState, String instrumentationScopeName) {
        this.meterProviderSharedState = meterProviderSharedState;
        this.instrumentationScopeName = instrumentationScopeName;
    }

    @CanIgnoreReturnValue
    public MeterBuilder setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    @CanIgnoreReturnValue
    public MeterBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
        this.instrumentationScopeVersion = instrumentationScopeVersion;
        return this;
    }

    public Meter build() {
        MeterSharedState state = new MeterSharedState(this.meterProviderSharedState, this.instrumentationScopeName, this.instrumentationScopeVersion, this.schemaUrl);
        return new MicrometerMeter(state);
    }
}

