/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0017R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lokhttp3/CompressionInterceptor;", "Lokhttp3/Interceptor;", "algorithms", "", "Lokhttp3/CompressionInterceptor$DecompressionAlgorithm;", "<init>", "([Lokhttp3/CompressionInterceptor$DecompressionAlgorithm;)V", "getAlgorithms", "()[Lokhttp3/CompressionInterceptor$DecompressionAlgorithm;", "[Lokhttp3/CompressionInterceptor$DecompressionAlgorithm;", "acceptEncoding", "", "getAcceptEncoding$okhttp", "()Ljava/lang/String;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "decompress", "response", "decompress$okhttp", "lookupDecompressor", "encoding", "lookupDecompressor$okhttp", "DecompressionAlgorithm", "okhttp"})
@SourceDebugExtension(value={"SMAP\nCompressionInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressionInterceptor.kt\nokhttp3/CompressionInterceptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,96:1\n11561#2:97\n11896#2,3:98\n*S KotlinDebug\n*F\n+ 1 CompressionInterceptor.kt\nokhttp3/CompressionInterceptor\n*L\n39#1:97\n39#1:98,3\n*E\n"})
public class CompressionInterceptor
implements Interceptor {
    @NotNull
    private final DecompressionAlgorithm[] algorithms;
    @NotNull
    private final String acceptEncoding;

    /*
     * WARNING - void declaration
     */
    public CompressionInterceptor(DecompressionAlgorithm ... algorithms) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(algorithms, "algorithms");
        DecompressionAlgorithm[] decompressionAlgorithmArray = this.algorithms = algorithms;
        CompressionInterceptor compressionInterceptor = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEncoding());
        }
        compressionInterceptor.acceptEncoding = CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final DecompressionAlgorithm[] getAlgorithms() {
        return this.algorithms;
    }

    @NotNull
    public final String getAcceptEncoding$okhttp() {
        return this.acceptEncoding;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter(chain, "chain");
        if (!(this.algorithms.length == 0) && chain.request().header("Accept-Encoding") == null) {
            Request request = chain.request().newBuilder().header("Accept-Encoding", this.acceptEncoding).build();
            Response response2 = chain.proceed(request);
            response = this.decompress$okhttp(response2);
        } else {
            response = chain.proceed(chain.request());
        }
        return response;
    }

    @NotNull
    public final Response decompress$okhttp(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        if (!HttpHeaders.promisesBody(response)) {
            return response;
        }
        ResponseBody body = response.body();
        String string = Response.header$default(response, "Content-Encoding", null, 2, null);
        if (string == null) {
            return response;
        }
        String encoding = string;
        DecompressionAlgorithm decompressionAlgorithm = this.lookupDecompressor$okhttp(encoding);
        if (decompressionAlgorithm == null) {
            return response;
        }
        DecompressionAlgorithm algorithm = decompressionAlgorithm;
        BufferedSource decompressedSource = Okio.buffer(algorithm.decompress(body.source()));
        return response.newBuilder().removeHeader("Content-Encoding").removeHeader("Content-Length").body(ResponseBody.Companion.create(decompressedSource, body.contentType(), -1L)).build();
    }

    @Nullable
    public final DecompressionAlgorithm lookupDecompressor$okhttp(@NotNull String encoding) {
        DecompressionAlgorithm decompressionAlgorithm;
        block1: {
            Intrinsics.checkNotNullParameter(encoding, "encoding");
            DecompressionAlgorithm[] decompressionAlgorithmArray = this.algorithms;
            int n = decompressionAlgorithmArray.length;
            for (int i = 0; i < n; ++i) {
                DecompressionAlgorithm decompressionAlgorithm2;
                DecompressionAlgorithm it = decompressionAlgorithm2 = decompressionAlgorithmArray[i];
                boolean bl = false;
                if (!StringsKt.equals(it.getEncoding(), encoding, true)) continue;
                decompressionAlgorithm = decompressionAlgorithm2;
                break block1;
            }
            decompressionAlgorithm = null;
        }
        return decompressionAlgorithm;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lokhttp3/CompressionInterceptor$DecompressionAlgorithm;", "", "encoding", "", "getEncoding", "()Ljava/lang/String;", "decompress", "Lokio/Source;", "compressedSource", "Lokio/BufferedSource;", "okhttp"})
    public static interface DecompressionAlgorithm {
        @NotNull
        public String getEncoding();

        @NotNull
        public Source decompress(@NotNull BufferedSource var1);
    }
}

