/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven.handler;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.maven.MavenGoal;
import io.opentelemetry.maven.handler.MojoGoalExecutionHandler;
import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.ExecutionEvent;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SpringBootBuildImageHandler
implements MojoGoalExecutionHandler {
    private static final Logger logger = LoggerFactory.getLogger(SpringBootBuildImageHandler.class);

    SpringBootBuildImageHandler() {
    }

    @Override
    public List<MavenGoal> getSupportedGoals() {
        return Collections.singletonList(MavenGoal.create("org.springframework.boot", "spring-boot-maven-plugin", "build-image"));
    }

    @Override
    public void enrichSpan(SpanBuilder spanBuilder, ExecutionEvent executionEvent) {
        Xpp3Dom publishNode;
        String imageTag;
        String imageName;
        Xpp3Dom nameNode;
        Xpp3Dom imageNode;
        spanBuilder.setSpanKind(SpanKind.CLIENT);
        Xpp3Dom pluginNode = executionEvent.getMojoExecution().getConfiguration();
        String imageNameAndTag = null;
        if (pluginNode != null && (imageNode = pluginNode.getChild("image")) != null && (nameNode = imageNode.getChild("name")) != null) {
            imageNameAndTag = nameNode.getValue();
        }
        if (imageNameAndTag == null) {
            imageName = "docker.io/library/" + executionEvent.getProject().getArtifactId();
            imageTag = executionEvent.getProject().getVersion();
        } else {
            int colonIdx = imageNameAndTag.indexOf(58);
            if (colonIdx == -1) {
                imageName = imageNameAndTag;
                imageTag = "latest";
            } else {
                imageTag = imageNameAndTag.substring(colonIdx + 1);
                imageName = imageNameAndTag.substring(0, colonIdx);
            }
        }
        spanBuilder.setAttribute(MavenOtelSemanticAttributes.MAVEN_BUILD_CONTAINER_IMAGE_NAME, imageName);
        spanBuilder.setAttribute(MavenOtelSemanticAttributes.MAVEN_BUILD_CONTAINER_IMAGE_TAGS, Collections.singletonList(imageTag));
        Xpp3Dom xpp3Dom = publishNode = pluginNode == null ? null : pluginNode.getChild("publish");
        if (publishNode != null && Boolean.parseBoolean(publishNode.getValue())) {
            Xpp3Dom registryNode;
            Xpp3Dom dockerNode = pluginNode.getChild("docker");
            Xpp3Dom xpp3Dom2 = registryNode = dockerNode == null ? null : dockerNode.getChild("publishRegistry");
            if (registryNode != null) {
                String registryUrl;
                Xpp3Dom registryUrlNode = registryNode.getChild("url");
                String string = registryUrl = registryUrlNode == null ? null : registryUrlNode.getValue();
                if (registryUrl != null && (registryUrl.startsWith("http://") || registryUrl.startsWith("https://"))) {
                    spanBuilder.setAttribute(MavenOtelSemanticAttributes.MAVEN_BUILD_CONTAINER_REGISTRY_URL, registryUrl);
                    spanBuilder.setAttribute(UrlAttributes.URL_FULL, registryUrl);
                    spanBuilder.setAttribute(HttpAttributes.HTTP_REQUEST_METHOD, "POST");
                    try {
                        spanBuilder.setAttribute(MavenOtelSemanticAttributes.PEER_SERVICE, new URL(registryUrl).getHost());
                    }
                    catch (MalformedURLException e) {
                        logger.debug("Ignore exception parsing container registry URL", (Throwable)e);
                    }
                }
            }
        }
    }
}

