/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.maven.OpenTelemetrySdkService;
import io.opentelemetry.maven.SpanRegistry;
import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.incubating.HttpIncubatingAttributes;
import io.opentelemetry.semconv.incubating.UrlIncubatingAttributes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OtelTransferListener
extends AbstractTransferListener {
    private static final Logger logger = LoggerFactory.getLogger(OtelTransferListener.class);
    private final SpanRegistry spanRegistry;
    private final OpenTelemetrySdkService openTelemetrySdkService;
    private final Map<String, Optional<URI>> repositoryUriMapping = new ConcurrentHashMap<String, Optional<URI>>();

    OtelTransferListener(SpanRegistry spanRegistry, OpenTelemetrySdkService openTelemetrySdkService) {
        this.spanRegistry = spanRegistry;
        this.openTelemetrySdkService = openTelemetrySdkService;
    }

    public void transferInitiated(TransferEvent event) {
        String httpRequestMethod;
        logger.debug("OpenTelemetry: OtelTransferListener#transferInitiated({})", (Object)event);
        switch (event.getRequestType()) {
            case PUT: {
                httpRequestMethod = "PUT";
                break;
            }
            case GET: {
                httpRequestMethod = "GET";
                break;
            }
            case GET_EXISTENCE: {
                httpRequestMethod = "HEAD";
                break;
            }
            default: {
                logger.warn("OpenTelemetry: Unknown request type {} for event {}", (Object)event.getRequestType(), (Object)event);
                httpRequestMethod = event.getRequestType().name();
            }
        }
        String urlTemplate = event.getResource().getRepositoryUrl() + "$groupId/$artifactId/$version/$artifactId-$version.$classifier";
        String spanName = httpRequestMethod + " " + urlTemplate;
        SpanBuilder spanBuilder = this.openTelemetrySdkService.getTracer().spanBuilder(spanName).setSpanKind(SpanKind.CLIENT).setAttribute(HttpAttributes.HTTP_REQUEST_METHOD, httpRequestMethod).setAttribute(UrlAttributes.URL_PATH, event.getResource().getRepositoryUrl() + event.getResource().getResourceName()).setAttribute(UrlIncubatingAttributes.URL_TEMPLATE, urlTemplate).setAttribute(MavenOtelSemanticAttributes.MAVEN_TRANSFER_TYPE, event.getRequestType().name()).setAttribute(MavenOtelSemanticAttributes.MAVEN_RESOURCE_NAME, event.getResource().getResourceName());
        this.repositoryUriMapping.computeIfAbsent(event.getResource().getRepositoryUrl(), str -> {
            try {
                return str.isEmpty() ? Optional.empty() : Optional.of(new URI((String)str));
            }
            catch (URISyntaxException e) {
                return Optional.empty();
            }
        }).ifPresent(uri -> {
            spanBuilder.setAttribute(ServerAttributes.SERVER_ADDRESS, uri.getHost());
            if (uri.getPort() != -1) {
                spanBuilder.setAttribute(ServerAttributes.SERVER_PORT, uri.getPort());
            }
            if (this.repositoryUriMapping.size() > 128) {
                this.repositoryUriMapping.clear();
            }
        });
        this.spanRegistry.putSpan(spanBuilder.startSpan(), event);
    }

    public void transferSucceeded(TransferEvent event) {
        logger.debug("OpenTelemetry: OtelTransferListener#transferSucceeded({})", (Object)event);
        Optional.ofNullable(this.spanRegistry.removeSpan(event)).ifPresent(span -> {
            span.setStatus(StatusCode.OK);
            this.finish((Span)span, event);
        });
    }

    public void transferFailed(TransferEvent event) {
        logger.debug("OpenTelemetry: OtelTransferListener#transferFailed({})", (Object)event);
        Optional.ofNullable(this.spanRegistry.removeSpan(event)).ifPresent(span -> this.fail((Span)span, event));
    }

    public void transferCorrupted(TransferEvent event) {
        logger.debug("OpenTelemetry: OtelTransferListener#transferCorrupted({})", (Object)event);
        Optional.ofNullable(this.spanRegistry.removeSpan(event)).ifPresent(span -> this.fail((Span)span, event));
    }

    void finish(Span span, TransferEvent event) {
        switch (event.getRequestType()) {
            case PUT: {
                span.setAttribute(HttpIncubatingAttributes.HTTP_REQUEST_BODY_SIZE, Long.valueOf(event.getTransferredBytes()));
                break;
            }
            case GET: 
            case GET_EXISTENCE: {
                span.setAttribute(HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, Long.valueOf(event.getTransferredBytes()));
            }
        }
        span.end();
    }

    void fail(Span span, TransferEvent event) {
        span.setStatus(StatusCode.ERROR, Optional.ofNullable(event.getException()).map(Throwable::getMessage).orElse("n/a"));
        this.finish(span, event);
    }
}

