/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.maven.ChainedExecutionListener;
import io.opentelemetry.maven.ChainedTransferListener;
import io.opentelemetry.maven.OpenTelemetrySdkService;
import io.opentelemetry.maven.OtelExecutionListener;
import io.opentelemetry.maven.OtelTransferListener;
import io.opentelemetry.maven.SpanRegistry;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public final class OtelLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(OtelLifecycleParticipant.class);
    private final OpenTelemetrySdkService openTelemetrySdkService;
    private final OtelExecutionListener otelExecutionListener;
    private final OtelTransferListener otelTransferListener;

    @Inject
    OtelLifecycleParticipant(OpenTelemetrySdkService openTelemetrySdkService, SpanRegistry spanRegistry) {
        this.openTelemetrySdkService = openTelemetrySdkService;
        this.otelExecutionListener = new OtelExecutionListener(spanRegistry, openTelemetrySdkService);
        this.otelTransferListener = new OtelTransferListener(spanRegistry, openTelemetrySdkService);
    }

    public void afterSessionStart(MavenSession session) {
        if (this.openTelemetrySdkService.isTransferInstrumentationEnabled()) {
            this.registerTransferListener(session);
        }
    }

    public void afterProjectsRead(MavenSession session) {
        this.registerExecutionListener(session);
    }

    void registerExecutionListener(MavenSession session) {
        ExecutionListener initialExecutionListener = session.getRequest().getExecutionListener();
        if (initialExecutionListener instanceof ChainedExecutionListener || initialExecutionListener instanceof OtelExecutionListener) {
            logger.debug("OpenTelemetry: OpenTelemetry extension already registered as execution listener, skip.");
        } else if (initialExecutionListener == null) {
            session.getRequest().setExecutionListener((ExecutionListener)this.otelExecutionListener);
            logger.debug("OpenTelemetry: OpenTelemetry extension registered as execution listener. No execution listener initially defined");
        } else {
            session.getRequest().setExecutionListener((ExecutionListener)new ChainedExecutionListener(new ExecutionListener[]{this.otelExecutionListener, initialExecutionListener}));
            logger.debug("OpenTelemetry: OpenTelemetry extension registered as execution listener. InitialExecutionListener: {}", (Object)initialExecutionListener);
        }
    }

    void registerTransferListener(MavenSession session) {
        RepositorySystemSession repositorySession = session.getRepositorySession();
        TransferListener initialTransferListener = repositorySession.getTransferListener();
        if (initialTransferListener instanceof ChainedTransferListener || initialTransferListener instanceof OtelTransferListener) {
            logger.debug("OpenTelemetry: OpenTelemetry extension already registered as transfer listener, skip.");
        } else if (initialTransferListener == null) {
            this.setTransferListener((TransferListener)this.otelTransferListener, repositorySession, session);
            logger.debug("OpenTelemetry: OpenTelemetry extension registered as transfer listener. No transfer listener initially defined");
        } else {
            this.setTransferListener(new ChainedTransferListener(new TransferListener[]{this.otelTransferListener, initialTransferListener}), repositorySession, session);
            logger.debug("OpenTelemetry: OpenTelemetry extension registered as transfer listener. InitialTransferListener: {}", (Object)initialTransferListener);
        }
    }

    void setTransferListener(TransferListener transferListener, RepositorySystemSession repositorySession, MavenSession session) {
        if (repositorySession instanceof DefaultRepositorySystemSession) {
            ((DefaultRepositorySystemSession)repositorySession).setTransferListener(transferListener);
        } else {
            logger.warn("OpenTelemetry: Cannot set transfer listener");
        }
    }

    public void afterSessionEnd(MavenSession session) {
        logger.debug("OpenTelemetry: After Maven session end, close OpenTelemetry SDK");
        this.openTelemetrySdkService.close();
    }
}

