/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;

final class ChainedTransferListener
implements TransferListener {
    private final List<TransferListener> listeners;

    ChainedTransferListener(TransferListener ... listeners) {
        this.listeners = Arrays.stream(listeners).filter(e -> e != null).collect(Collectors.toList());
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        for (TransferListener listener : this.listeners) {
            listener.transferInitiated(event);
        }
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        for (TransferListener listener : this.listeners) {
            listener.transferStarted(event);
        }
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        for (TransferListener listener : this.listeners) {
            listener.transferProgressed(event);
        }
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        for (TransferListener listener : this.listeners) {
            listener.transferCorrupted(event);
        }
    }

    public void transferSucceeded(TransferEvent event) {
        for (TransferListener listener : this.listeners) {
            listener.transferSucceeded(event);
        }
    }

    public void transferFailed(TransferEvent event) {
        for (TransferListener listener : this.listeners) {
            listener.transferFailed(event);
        }
    }
}

