/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.opentelemetry.maven.MavenGoal;
import io.opentelemetry.maven.MavenUtils;
import io.opentelemetry.maven.OpenTelemetrySdkService;
import io.opentelemetry.maven.SpanRegistry;
import io.opentelemetry.maven.ToUpperCaseTextMapGetter;
import io.opentelemetry.maven.handler.MojoGoalExecutionHandler;
import io.opentelemetry.maven.handler.MojoGoalExecutionHandlerConfiguration;
import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OtelExecutionListener
extends AbstractExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(OtelExecutionListener.class);
    private static final ThreadLocal<Scope> MOJO_EXECUTION_SCOPE = new ThreadLocal();
    private final SpanRegistry spanRegistry;
    private final OpenTelemetrySdkService openTelemetrySdkService;
    private final Map<MavenGoal, MojoGoalExecutionHandler> mojoGoalExecutionHandlers;

    OtelExecutionListener(SpanRegistry spanRegistry, OpenTelemetrySdkService openTelemetrySdkService) {
        this.spanRegistry = spanRegistry;
        this.openTelemetrySdkService = openTelemetrySdkService;
        this.mojoGoalExecutionHandlers = MojoGoalExecutionHandlerConfiguration.loadMojoGoalExecutionHandler(OtelExecutionListener.class.getClassLoader());
        if (logger.isDebugEnabled()) {
            logger.debug("OpenTelemetry: mojoGoalExecutionHandlers: " + this.mojoGoalExecutionHandlers.entrySet().stream().map(entry -> ((MavenGoal)entry.getKey()).toString() + ": " + ((MojoGoalExecutionHandler)entry.getValue()).toString()).collect(Collectors.joining(", ")));
            ContextStorage contextStorage = ContextStorage.get();
            logger.debug("ContextStorage: " + contextStorage + ", identity=" + System.identityHashCode(contextStorage));
            Class<?> contextStorageClass = contextStorage.getClass();
            logger.debug("ContextStorageClass=" + contextStorageClass.getName() + ", identity=" + System.identityHashCode(contextStorageClass) + " classloader=" + contextStorageClass.getClassLoader() + " codeLocation=" + Optional.of(contextStorageClass.getProtectionDomain().getCodeSource()).map(source2 -> source2.getLocation().toString()).orElse("#unknown#"));
        }
    }

    public void sessionStarted(ExecutionEvent executionEvent) {
        MavenProject project = executionEvent.getSession().getTopLevelProject();
        ToUpperCaseTextMapGetter toUpperCaseTextMapGetter = new ToUpperCaseTextMapGetter();
        Context context = this.openTelemetrySdkService.getPropagators().getTextMapPropagator().extract(Context.current(), System.getenv(), toUpperCaseTextMapGetter);
        String spanName = "Build: " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion();
        logger.debug("OpenTelemetry: Start session span: {}", (Object)spanName);
        Span sessionSpan = this.openTelemetrySdkService.getTracer().spanBuilder(spanName).setParent(context).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_GROUP_ID, project.getGroupId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_ARTIFACT_ID, project.getArtifactId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_VERSION, project.getVersion()).setSpanKind(SpanKind.SERVER).startSpan();
        this.spanRegistry.setRootSpan(sessionSpan);
    }

    public void projectStarted(ExecutionEvent executionEvent) {
        MavenProject project = executionEvent.getProject();
        String spanName = project.getGroupId() + ":" + project.getArtifactId();
        logger.debug("OpenTelemetry: Start project span: {}", (Object)spanName);
        Span rootSpan = this.spanRegistry.getRootSpanNotNull();
        Tracer tracer = this.openTelemetrySdkService.getTracer();
        Span projectSpan = tracer.spanBuilder(spanName).setParent(Context.current().with(Span.wrap(rootSpan.getSpanContext()))).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_GROUP_ID, project.getGroupId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_ARTIFACT_ID, project.getArtifactId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_VERSION, project.getVersion()).startSpan();
        this.spanRegistry.putSpan(projectSpan, project);
    }

    public void projectSucceeded(ExecutionEvent executionEvent) {
        logger.debug("OpenTelemetry: End succeeded project span: {}:{}", (Object)executionEvent.getProject().getArtifactId(), (Object)executionEvent.getProject().getArtifactId());
        this.spanRegistry.removeSpan(executionEvent.getProject()).end();
    }

    public void projectFailed(ExecutionEvent executionEvent) {
        logger.debug("OpenTelemetry: End failed project span: {}:{}", (Object)executionEvent.getProject().getArtifactId(), (Object)executionEvent.getProject().getArtifactId());
        Span span = this.spanRegistry.removeSpan(executionEvent.getProject());
        span.setStatus(StatusCode.ERROR);
        span.recordException(executionEvent.getException());
        span.end();
    }

    public void mojoStarted(ExecutionEvent executionEvent) {
        if (!this.openTelemetrySdkService.isMojosInstrumentationEnabled()) {
            return;
        }
        MojoExecution mojoExecution = executionEvent.getMojoExecution();
        Span rootSpan = this.spanRegistry.getSpan(executionEvent.getProject());
        String spanName = MavenUtils.getPluginArtifactIdShortName(mojoExecution.getArtifactId()) + ":" + mojoExecution.getGoal();
        logger.debug("OpenTelemetry: Start mojo execution: span {}", (Object)spanName);
        SpanBuilder spanBuilder = this.openTelemetrySdkService.getTracer().spanBuilder(spanName).setParent(Context.current().with(Span.wrap(rootSpan.getSpanContext()))).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_GROUP_ID, executionEvent.getProject().getGroupId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_ARTIFACT_ID, executionEvent.getProject().getArtifactId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_VERSION, executionEvent.getProject().getVersion()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PLUGIN_GROUP_ID, mojoExecution.getPlugin().getGroupId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PLUGIN_ARTIFACT_ID, mojoExecution.getPlugin().getArtifactId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PLUGIN_VERSION, mojoExecution.getPlugin().getVersion()).setAttribute(MavenOtelSemanticAttributes.MAVEN_EXECUTION_GOAL, mojoExecution.getGoal()).setAttribute(MavenOtelSemanticAttributes.MAVEN_EXECUTION_ID, mojoExecution.getExecutionId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_EXECUTION_LIFECYCLE_PHASE, mojoExecution.getLifecyclePhase());
        MojoGoalExecutionHandler handler = this.mojoGoalExecutionHandlers.get(MavenGoal.create(mojoExecution));
        logger.debug("OpenTelemetry: {} handler {}", (Object)executionEvent, (Object)handler);
        if (handler != null) {
            handler.enrichSpan(spanBuilder, executionEvent);
        }
        Span span = spanBuilder.startSpan();
        Scope scope = span.makeCurrent();
        this.spanRegistry.putSpan(span, mojoExecution, executionEvent.getProject());
        Optional.ofNullable(MOJO_EXECUTION_SCOPE.get()).ifPresent(previousScope -> logger.warn("OpenTelemetry: Scope " + System.identityHashCode(previousScope) + "already attached to thread '" + Thread.currentThread().getName() + "'"));
        MOJO_EXECUTION_SCOPE.set(scope);
        if (logger.isDebugEnabled()) {
            logger.debug("OpenTelemetry: Attach scope " + System.identityHashCode(scope) + " to thread '" + Thread.currentThread().getName() + "' for " + mojoExecution);
        }
    }

    public void mojoSucceeded(ExecutionEvent executionEvent) {
        if (!this.openTelemetrySdkService.isMojosInstrumentationEnabled()) {
            return;
        }
        MojoExecution mojoExecution = executionEvent.getMojoExecution();
        logger.debug("OpenTelemetry: End succeeded mojo execution span: {}, {}", (Object)mojoExecution, (Object)executionEvent.getProject());
        Span mojoExecutionSpan = this.spanRegistry.removeSpan(mojoExecution, executionEvent.getProject());
        mojoExecutionSpan.setStatus(StatusCode.OK);
        mojoExecutionSpan.end();
        Scope scope = MOJO_EXECUTION_SCOPE.get();
        if (scope == null) {
            logger.warn("OpenTelemetry: No scope found on thread '" + Thread.currentThread().getName() + "' for succeeded " + mojoExecution);
        } else {
            scope.close();
            MOJO_EXECUTION_SCOPE.remove();
            if (logger.isDebugEnabled()) {
                logger.debug("OpenTelemetry: Remove scope " + System.identityHashCode(scope) + " on thread '" + Thread.currentThread().getName() + "' for succeeded " + mojoExecution);
            }
        }
    }

    public void mojoFailed(ExecutionEvent executionEvent) {
        if (!this.openTelemetrySdkService.isMojosInstrumentationEnabled()) {
            return;
        }
        MojoExecution mojoExecution = executionEvent.getMojoExecution();
        logger.debug("OpenTelemetry: End failed mojo execution span: {}, {}", (Object)mojoExecution, (Object)executionEvent.getProject());
        Span mojoExecutionSpan = this.spanRegistry.removeSpan(mojoExecution, executionEvent.getProject());
        mojoExecutionSpan.setStatus(StatusCode.ERROR, "Mojo Failed");
        Throwable exception = executionEvent.getException();
        if (exception instanceof LifecycleExecutionException) {
            LifecycleExecutionException executionException = (LifecycleExecutionException)exception;
            exception = executionException.getCause();
        }
        if (exception != null) {
            mojoExecutionSpan.recordException(exception);
        }
        mojoExecutionSpan.end();
        Scope scope = MOJO_EXECUTION_SCOPE.get();
        if (scope == null) {
            logger.warn("OpenTelemetry: No scope found on thread '" + Thread.currentThread().getName() + "' for failed " + mojoExecution);
        } else {
            scope.close();
            MOJO_EXECUTION_SCOPE.remove();
            if (logger.isDebugEnabled()) {
                logger.debug("OpenTelemetry: Remove scope " + System.identityHashCode(scope) + " on thread '" + Thread.currentThread().getName() + "' for failed " + mojoExecution);
            }
        }
    }

    public void sessionEnded(ExecutionEvent event) {
        logger.debug("OpenTelemetry: Maven session ended, end root span");
        this.spanRegistry.removeRootSpan().end();
    }
}

