/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven.resources;

import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.Maven;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenResourceProvider
implements ResourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(MavenResourceProvider.class);

    @Override
    public Resource createResource(ConfigProperties config) {
        return Resource.builder().put(ServiceAttributes.SERVICE_NAME, "maven").put(ServiceAttributes.SERVICE_VERSION, MavenResourceProvider.getMavenRuntimeVersion()).put(MavenOtelSemanticAttributes.TELEMETRY_DISTRO_NAME, "opentelemetry-maven-extension").put(MavenOtelSemanticAttributes.TELEMETRY_DISTRO_VERSION, MavenOtelSemanticAttributes.TELEMETRY_DISTRO_VERSION_VALUE).build();
    }

    static String getMavenRuntimeVersion() {
        Properties props = new Properties();
        String resource = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
        try (InputStream is = Maven.class.getResourceAsStream("/" + resource);){
            if (is != null) {
                props.load(is);
            } else {
                logger.warn("Could not locate {} on classpath, Maven runtime information not available", (Object)resource);
            }
        }
        catch (IOException e) {
            String msg = "Could not parse " + resource + ", Maven runtime information not available";
            if (logger.isDebugEnabled()) {
                logger.warn(msg, (Throwable)e);
            }
            logger.warn(msg);
        }
        String version = props.getProperty("version", "").trim();
        String mavenVersion = !version.startsWith("${") ? version : "";
        return mavenVersion;
    }
}

