/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.maven.AutoConfigureUtil2;
import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public final class OpenTelemetrySdkService
implements Closeable {
    static final String VERSION = OpenTelemetrySdkService.class.getPackage().getImplementationVersion();
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetrySdkService.class);
    private final OpenTelemetrySdk openTelemetrySdk;
    @VisibleForTesting
    final Resource resource;
    private final ConfigProperties configProperties;
    private final Tracer tracer;
    private final boolean mojosInstrumentationEnabled;
    private final boolean transferInstrumentationEnabled;
    private boolean disposed;

    public OpenTelemetrySdkService() {
        logger.info("OpenTelemetry: Initialize OpenTelemetrySdkService v{}...", (Object)MavenOtelSemanticAttributes.TELEMETRY_DISTRO_VERSION_VALUE);
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk = ((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder().setServiceClassLoader(this.getClass().getClassLoader()).addPropertiesCustomizer(OpenTelemetrySdkService::requireExplicitConfigOfTheOtlpExporter)).disableShutdownHook().build();
        this.openTelemetrySdk = autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk();
        this.configProperties = Optional.ofNullable(AutoConfigureUtil.getConfig(autoConfiguredOpenTelemetrySdk)).orElseGet(() -> DefaultConfigProperties.createFromMap(Collections.emptyMap()));
        this.resource = AutoConfigureUtil2.getResource(autoConfiguredOpenTelemetrySdk);
        logger.debug("OpenTelemetry: OpenTelemetrySdkService initialized, resource:{}", (Object)this.resource);
        this.mojosInstrumentationEnabled = this.configProperties.getBoolean("otel.instrumentation.maven.mojo.enabled", true);
        this.transferInstrumentationEnabled = this.configProperties.getBoolean("otel.instrumentation.maven.transfer.enabled", false);
        this.tracer = this.openTelemetrySdk.getTracer("io.opentelemetry.contrib.maven", VERSION);
    }

    static Map<String, String> requireExplicitConfigOfTheOtlpExporter(ConfigProperties configProperties) {
        String[] signalTypes;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (configProperties.getString("otel.exporter.otlp.endpoint") != null) {
            logger.debug("OpenTelemetry: OTLP exporter endpoint is explicitly configured");
            return properties;
        }
        for (String signalType : signalTypes = new String[]{"traces", "metrics", "logs"}) {
            boolean isOtlpExporterEndpointSpecified;
            boolean isExporterImplicitlyConfiguredToOtlp = configProperties.getString("otel." + signalType + ".exporter") == null;
            boolean bl = isOtlpExporterEndpointSpecified = configProperties.getString("otel.exporter.otlp." + signalType + ".endpoint") != null;
            if (!isExporterImplicitlyConfiguredToOtlp || isOtlpExporterEndpointSpecified) continue;
            logger.debug("OpenTelemetry: Disabling default OTLP exporter endpoint for signal {} exporter", (Object)signalType);
            properties.put("otel." + signalType + ".exporter", "none");
        }
        return properties;
    }

    @Override
    @PreDestroy
    public synchronized void close() {
        if (this.disposed) {
            logger.debug("OpenTelemetry: OpenTelemetry SDK already shut down, ignore");
        } else {
            logger.debug("OpenTelemetry: Shutdown OpenTelemetry SDK...");
            CompletableResultCode openTelemetrySdkShutdownResult = this.openTelemetrySdk.shutdown().join(10L, TimeUnit.SECONDS);
            if (openTelemetrySdkShutdownResult.isSuccess()) {
                logger.debug("OpenTelemetry: OpenTelemetry SDK successfully shut down");
            } else {
                logger.warn("OpenTelemetry: Failure to shutdown OpenTelemetry SDK (done: {})", (Object)openTelemetrySdkShutdownResult.isDone());
            }
            this.disposed = true;
        }
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public ConfigProperties getConfigProperties() {
        return this.configProperties;
    }

    public ContextPropagators getPropagators() {
        return this.openTelemetrySdk.getPropagators();
    }

    public boolean isMojosInstrumentationEnabled() {
        return this.mojosInstrumentationEnabled;
    }

    public boolean isTransferInstrumentationEnabled() {
        return this.transferInstrumentationEnabled;
    }
}

