/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.maven.ChainedExecutionListener;
import io.opentelemetry.maven.OpenTelemetrySdkService;
import io.opentelemetry.maven.OtelExecutionListener;
import io.opentelemetry.maven.SpanRegistry;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public final class OtelLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(OtelLifecycleParticipant.class);
    private final OpenTelemetrySdkService openTelemetrySdkService;
    private final OtelExecutionListener otelExecutionListener;

    @Inject
    OtelLifecycleParticipant(OpenTelemetrySdkService openTelemetrySdkService, SpanRegistry spanRegistry) {
        this.openTelemetrySdkService = openTelemetrySdkService;
        this.otelExecutionListener = new OtelExecutionListener(spanRegistry, openTelemetrySdkService);
    }

    public void afterProjectsRead(MavenSession session) {
        ExecutionListener initialExecutionListener = session.getRequest().getExecutionListener();
        if (initialExecutionListener instanceof ChainedExecutionListener || initialExecutionListener instanceof OtelExecutionListener) {
            logger.debug("OpenTelemetry: OpenTelemetry extension already registered as execution listener, skip.");
        } else if (initialExecutionListener == null) {
            session.getRequest().setExecutionListener((ExecutionListener)this.otelExecutionListener);
            logger.debug("OpenTelemetry: OpenTelemetry extension registered as execution listener. No execution listener initially defined");
        } else {
            session.getRequest().setExecutionListener((ExecutionListener)new ChainedExecutionListener(new ExecutionListener[]{this.otelExecutionListener, initialExecutionListener}));
            logger.debug("OpenTelemetry: OpenTelemetry extension registered as execution listener. InitialExecutionListener: {}", (Object)initialExecutionListener);
        }
    }

    public void afterSessionEnd(MavenSession session) {
        logger.debug("OpenTelemetry: After Maven session end, close OpenTelemetry SDK");
        this.openTelemetrySdkService.close();
    }
}

