/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public final class OpenTelemetrySdkService
implements Closeable {
    static final String VERSION = OpenTelemetrySdkService.class.getPackage().getImplementationVersion();
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetrySdkService.class);
    private final OpenTelemetrySdk openTelemetrySdk;
    private final Tracer tracer;
    private final boolean mojosInstrumentationEnabled;
    private boolean disposed;

    public OpenTelemetrySdkService() {
        logger.debug("OpenTelemetry: Initialize OpenTelemetrySdkService v{}...", (Object)MavenOtelSemanticAttributes.TELEMETRY_DISTRO_VERSION_VALUE);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("otel.traces.exporter", "none");
        properties.put("otel.metrics.exporter", "none");
        properties.put("otel.logs.exporter", "none");
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk = ((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder().setServiceClassLoader(this.getClass().getClassLoader()).addPropertiesSupplier(() -> properties)).disableShutdownHook().build();
        this.openTelemetrySdk = autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk();
        Boolean mojoSpansEnabled = OpenTelemetrySdkService.getBooleanConfig("otel.instrumentation.maven.mojo.enabled");
        this.mojosInstrumentationEnabled = mojoSpansEnabled == null || mojoSpansEnabled != false;
        this.tracer = this.openTelemetrySdk.getTracer("io.opentelemetry.contrib.maven", VERSION);
    }

    @Override
    @PreDestroy
    public synchronized void close() {
        if (this.disposed) {
            logger.debug("OpenTelemetry: OpenTelemetry SDK already shut down, ignore");
        } else {
            logger.debug("OpenTelemetry: Shutdown OpenTelemetry SDK...");
            CompletableResultCode openTelemetrySdkShutdownResult = this.openTelemetrySdk.shutdown().join(10L, TimeUnit.SECONDS);
            if (openTelemetrySdkShutdownResult.isSuccess()) {
                logger.debug("OpenTelemetry: OpenTelemetry SDK successfully shut down");
            } else {
                logger.warn("OpenTelemetry: Failure to shutdown OpenTelemetry SDK (done: {})", (Object)openTelemetrySdkShutdownResult.isDone());
            }
            this.disposed = true;
        }
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public ContextPropagators getPropagators() {
        return this.openTelemetrySdk.getPropagators();
    }

    public boolean isMojosInstrumentationEnabled() {
        return this.mojosInstrumentationEnabled;
    }

    @Nullable
    private static Boolean getBooleanConfig(String name) {
        String value = System.getProperty(name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        value = System.getenv(name.toUpperCase(Locale.ROOT).replace('.', '_'));
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }
}

