/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.events;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.logs.AnyValue;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public interface EventBuilder {
    default public EventBuilder put(String key, String value) {
        return this.put(key, AnyValue.of(value));
    }

    default public EventBuilder put(String key, long value) {
        return this.put(key, AnyValue.of(value));
    }

    default public EventBuilder put(String key, double value) {
        return this.put(key, AnyValue.of(value));
    }

    default public EventBuilder put(String key, boolean value) {
        return this.put(key, AnyValue.of(value));
    }

    default public EventBuilder put(String key, String ... value) {
        ArrayList values2 = new ArrayList(value.length);
        for (String val : value) {
            values2.add(AnyValue.of(val));
        }
        return this.put(key, AnyValue.of(values2));
    }

    default public EventBuilder put(String key, long ... value) {
        ArrayList values2 = new ArrayList(value.length);
        for (long val : value) {
            values2.add(AnyValue.of(val));
        }
        return this.put(key, AnyValue.of(values2));
    }

    default public EventBuilder put(String key, double ... value) {
        ArrayList values2 = new ArrayList(value.length);
        for (double val : value) {
            values2.add(AnyValue.of(val));
        }
        return this.put(key, AnyValue.of(values2));
    }

    default public EventBuilder put(String key, boolean ... value) {
        ArrayList values2 = new ArrayList(value.length);
        for (boolean val : value) {
            values2.add(AnyValue.of(val));
        }
        return this.put(key, AnyValue.of(values2));
    }

    public EventBuilder put(String var1, AnyValue<?> var2);

    public EventBuilder setTimestamp(long var1, TimeUnit var3);

    public EventBuilder setTimestamp(Instant var1);

    public EventBuilder setContext(Context var1);

    public EventBuilder setSeverity(Severity var1);

    public EventBuilder setAttributes(Attributes var1);

    public void emit();
}

