/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven.handler;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.maven.MavenGoal;
import io.opentelemetry.maven.handler.MojoGoalExecutionHandler;
import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MavenDeployHandler
implements MojoGoalExecutionHandler {
    private static final Logger logger = LoggerFactory.getLogger(MavenDeployHandler.class);

    MavenDeployHandler() {
    }

    @Override
    public void enrichSpan(SpanBuilder spanBuilder, ExecutionEvent execution) {
        spanBuilder.setSpanKind(SpanKind.CLIENT);
        MavenProject project = execution.getProject();
        ArtifactRepository optRepository = project.getDistributionManagementArtifactRepository();
        if (optRepository == null) {
            return;
        }
        spanBuilder.setAttribute(MavenOtelSemanticAttributes.MAVEN_BUILD_REPOSITORY_ID, optRepository.getId());
        spanBuilder.setAttribute(MavenOtelSemanticAttributes.MAVEN_BUILD_REPOSITORY_URL, optRepository.getUrl());
        String artifactRepositoryUrl = optRepository.getUrl();
        if (artifactRepositoryUrl != null && (artifactRepositoryUrl.startsWith("https://") || artifactRepositoryUrl.startsWith("http://"))) {
            try {
                spanBuilder.setAttribute(SemanticAttributes.PEER_SERVICE, new URL(artifactRepositoryUrl).getHost());
            }
            catch (MalformedURLException e) {
                logger.debug("Ignore exception parsing artifact repository URL", (Throwable)e);
            }
            Artifact artifact = project.getArtifact();
            String artifactRootUrl = artifactRepositoryUrl;
            if (!artifactRootUrl.endsWith("/")) {
                artifactRootUrl = artifactRootUrl + '/';
            }
            artifactRootUrl = artifactRootUrl + artifact.getGroupId().replace('.', '/') + '/' + artifact.getArtifactId() + '/' + artifact.getVersion();
            spanBuilder.setAttribute(SemanticAttributes.HTTP_URL, artifactRootUrl);
            spanBuilder.setAttribute(SemanticAttributes.HTTP_METHOD, "POST");
        }
    }

    @Override
    public List<MavenGoal> getSupportedGoals() {
        return Collections.singletonList(MavenGoal.create("org.apache.maven.plugins", "maven-deploy-plugin", "deploy"));
    }
}

