/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=OpenTelemetrySdkService.class, hint="opentelemetry-service")
public final class OpenTelemetrySdkService
implements Initializable,
Disposable {
    static final String VERSION = OpenTelemetrySdkService.class.getPackage().getImplementationVersion();
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetrySdkService.class);
    private OpenTelemetry openTelemetry = OpenTelemetry.noop();
    @Nullable
    private OpenTelemetrySdk openTelemetrySdk;
    @Nullable
    private Tracer tracer;
    private boolean mojosInstrumentationEnabled;
    @Nullable
    AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk;

    public synchronized void dispose() {
        logger.debug("OpenTelemetry: dispose OpenTelemetrySdkService...");
        OpenTelemetrySdk openTelemetrySdk = this.openTelemetrySdk;
        if (openTelemetrySdk != null) {
            logger.debug("OpenTelemetry: Shutdown SDK Trace Provider...");
            CompletableResultCode sdkProviderShutdown = openTelemetrySdk.getSdkTracerProvider().shutdown();
            sdkProviderShutdown.join(10L, TimeUnit.SECONDS);
            if (sdkProviderShutdown.isSuccess()) {
                logger.debug("OpenTelemetry: SDK Trace Provider shut down");
            } else {
                logger.warn("OpenTelemetry: Failure to shutdown SDK Trace Provider (done: " + sdkProviderShutdown.isDone() + ")");
            }
            this.openTelemetrySdk = null;
        }
        this.openTelemetry = OpenTelemetry.noop();
        this.autoConfiguredOpenTelemetrySdk = null;
        logger.debug("OpenTelemetry: OpenTelemetrySdkService disposed");
    }

    public void initialize() {
        logger.debug("OpenTelemetry: Initialize OpenTelemetrySdkService v{}...", (Object)VERSION);
        Map<String, String> properties = Collections.singletonMap("otel.traces.exporter", "none");
        this.autoConfiguredOpenTelemetrySdk = ((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder().setServiceClassLoader(this.getClass().getClassLoader()).addPropertiesSupplier(() -> properties)).disableShutdownHook().build();
        if (logger.isDebugEnabled()) {
            logger.debug("OpenTelemetry: OpenTelemetry SDK initialized");
        }
        this.openTelemetrySdk = this.autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk();
        this.openTelemetry = this.openTelemetrySdk;
        Boolean mojoSpansEnabled = OpenTelemetrySdkService.getBooleanConfig("otel.instrumentation.maven.mojo.enabled");
        this.mojosInstrumentationEnabled = mojoSpansEnabled == null ? true : mojoSpansEnabled;
        this.tracer = this.openTelemetry.getTracer("io.opentelemetry.contrib.maven", VERSION);
    }

    public Tracer getTracer() {
        Tracer tracer = this.tracer;
        if (tracer == null) {
            throw new IllegalStateException("Not initialized");
        }
        return tracer;
    }

    public ContextPropagators getPropagators() {
        return this.openTelemetry.getPropagators();
    }

    public boolean isMojosInstrumentationEnabled() {
        return this.mojosInstrumentationEnabled;
    }

    @Nullable
    private static Boolean getBooleanConfig(String name) {
        String value = System.getProperty(name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        value = System.getenv(name.toUpperCase(Locale.ROOT).replace('.', '_'));
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }
}

