/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.maven.OtelExecutionListener;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=AbstractMavenLifecycleParticipant.class)
public final class OtelLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(OtelLifecycleParticipant.class);
    @Requirement(role=ExecutionListener.class, hint="otel-execution-listener")
    private OtelExecutionListener otelExecutionListener;

    public void afterProjectsRead(MavenSession session) {
        OtelExecutionListener.registerOtelExecutionListener(session, this.otelExecutionListener);
        logger.debug("OpenTelemetry: afterProjectsRead");
    }

    public void afterSessionStart(MavenSession session) {
        OtelExecutionListener.registerOtelExecutionListener(session, this.otelExecutionListener);
        logger.debug("OpenTelemetry: afterSessionStart");
    }

    public void afterSessionEnd(MavenSession session) {
        logger.debug("OpenTelemetry: afterSessionEnd");
    }
}

