/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.logs;

import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcLogRecordExporter
implements LogRecordExporter {
    private final GrpcExporter<LogsRequestMarshaler> delegate;

    public static OtlpGrpcLogRecordExporter getDefault() {
        return OtlpGrpcLogRecordExporter.builder().build();
    }

    public static OtlpGrpcLogRecordExporterBuilder builder() {
        return new OtlpGrpcLogRecordExporterBuilder();
    }

    OtlpGrpcLogRecordExporter(GrpcExporter<LogsRequestMarshaler> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        LogsRequestMarshaler request = LogsRequestMarshaler.create(logs);
        return this.delegate.export(request, logs.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

