/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.kafka;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.kafka.KafkaSpanExporter;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaSpanExporterBuilder {
    private static final long DEFAULT_TIMEOUT_IN_SECONDS = 5L;
    private String topicName;
    private Producer<String, Collection<SpanData>> producer;
    private ExecutorService executorService;
    private long timeoutInSeconds = 5L;

    @CanIgnoreReturnValue
    public KafkaSpanExporterBuilder setTopicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaSpanExporterBuilder setProducer(Producer<String, Collection<SpanData>> producer) {
        this.producer = producer;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaSpanExporterBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaSpanExporterBuilder setTimeoutInSeconds(long timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    public KafkaSpanExporter build() {
        if (Objects.isNull(this.topicName)) {
            throw new IllegalArgumentException("topicName cannot be null");
        }
        if (Objects.isNull(this.producer)) {
            throw new IllegalArgumentException("producer cannot be null");
        }
        if (Objects.isNull(this.executorService)) {
            this.executorService = Executors.newCachedThreadPool();
        }
        return new KafkaSpanExporter(this.topicName, this.producer, this.executorService, this.timeoutInSeconds);
    }

    public static class ProducerBuilder {
        private Map<String, Object> config;
        private Serializer<String> keySerializer;
        private Serializer<Collection<SpanData>> valueSerializer;

        public static ProducerBuilder newInstance() {
            return new ProducerBuilder();
        }

        @CanIgnoreReturnValue
        public ProducerBuilder setConfig(Map<String, Object> config) {
            this.config = config;
            return this;
        }

        @CanIgnoreReturnValue
        public ProducerBuilder setKeySerializer(Serializer<String> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        @CanIgnoreReturnValue
        public ProducerBuilder setValueSerializer(Serializer<Collection<SpanData>> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public Producer<String, Collection<SpanData>> build() {
            boolean correctConfig;
            if (Objects.isNull(this.config)) {
                throw new IllegalArgumentException("producer configuration cannot be null");
            }
            boolean bl = correctConfig = (this.config.containsKey("key.serializer") && this.config.containsKey("value.serializer")) ^ (Objects.nonNull(this.keySerializer) && Objects.nonNull(this.valueSerializer)) && this.config.containsKey("key.serializer") ^ Objects.nonNull(this.valueSerializer) && this.config.containsKey("value.serializer") ^ Objects.nonNull(this.keySerializer);
            if (!correctConfig) {
                throw new IllegalArgumentException("Both the key and value serializers should be provided either in the configuration or by using the corresponding setters");
            }
            if (this.config.containsKey("key.serializer")) {
                return new KafkaProducer(this.config);
            }
            return new KafkaProducer(this.config, this.keySerializer, this.valueSerializer);
        }
    }
}

