/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.kafka;

import io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansMarshaler;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class SpanDataSerializer
implements Serializer<Collection<SpanData>> {
    public byte[] serialize(String topic, Collection<SpanData> data) {
        if (Objects.isNull(data)) {
            throw new SerializationException("Cannot serialize null");
        }
        return this.convertSpansToRequest(data).toByteArray();
    }

    ExportTraceServiceRequest convertSpansToRequest(Collection<SpanData> spans) {
        List resourceSpansList = Arrays.stream(ResourceSpansMarshaler.create(spans)).map(resourceSpansMarshaler -> {
            ResourceSpans resourceSpans;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                resourceSpansMarshaler.writeBinaryTo((OutputStream)baos);
                resourceSpans = ResourceSpans.parseFrom((byte[])baos.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SerializationException((Throwable)e);
                }
            }
            baos.close();
            return resourceSpans;
        }).collect(Collectors.toList());
        return ExportTraceServiceRequest.newBuilder().addAllResourceSpans(resourceSpansList).build();
    }
}

