/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.GlobalConfigProvider;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.resources.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class IncubatingUtil {
    private IncubatingUtil() {
    }

    static AutoConfiguredOpenTelemetrySdk configureFromFile(Logger logger, String configurationFile, ComponentLoader componentLoader) {
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk;
        logger.fine("Autoconfiguring from configuration file: " + configurationFile);
        FileInputStream fis = new FileInputStream(configurationFile);
        try {
            autoConfiguredOpenTelemetrySdk = Objects.requireNonNull(IncubatingUtil.createWithFactory("file", () -> IncubatingUtil.getOpenTelemetrySdk(Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration").getMethod("parse", InputStream.class).invoke(null, fis), componentLoader)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("Configuration file not found", e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error closing file", e);
            }
        }
        fis.close();
        return autoConfiguredOpenTelemetrySdk;
    }

    @Nullable
    public static AutoConfiguredOpenTelemetrySdk configureFromSpi(ComponentLoader componentLoader) {
        return IncubatingUtil.createWithFactory("SPI", () -> {
            Class<?> providerClass = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationProvider");
            Method getConfigurationModel = providerClass.getMethod("getConfigurationModel", new Class[0]);
            for (Object configProvider : componentLoader.load(providerClass)) {
                Object model = getConfigurationModel.invoke(configProvider, new Object[0]);
                if (model == null) continue;
                return IncubatingUtil.getOpenTelemetrySdk(model, componentLoader);
            }
            return null;
        });
    }

    private static AutoConfiguredOpenTelemetrySdk getOpenTelemetrySdk(Object model, ComponentLoader componentLoader) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        Class<?> openTelemetryConfiguration = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel");
        Class<?> declarativeConfiguration = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration");
        Class<?> contextClass = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext");
        Method createContext = contextClass.getDeclaredMethod("create", ComponentLoader.class);
        createContext.setAccessible(true);
        Object context = createContext.invoke(null, componentLoader);
        Method create = declarativeConfiguration.getDeclaredMethod("create", openTelemetryConfiguration, contextClass);
        create.setAccessible(true);
        OpenTelemetrySdk sdk = (OpenTelemetrySdk)create.invoke(null, model, context);
        Class<?> providerClass = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.SdkConfigProvider");
        Object provider = providerClass.getDeclaredMethod("create", openTelemetryConfiguration, ComponentLoader.class).invoke(null, model, componentLoader);
        Method getResource = contextClass.getDeclaredMethod("getResource", new Class[0]);
        getResource.setAccessible(true);
        Resource resource = (Resource)getResource.invoke(context, new Object[0]);
        return AutoConfiguredOpenTelemetrySdk.create(sdk, resource, null, provider);
    }

    @Nullable
    static AutoConfiguredOpenTelemetrySdk createWithFactory(String name, Factory factory) {
        try {
            return factory.create();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new ConfigurationException(String.format("Error configuring from %s. Is opentelemetry-sdk-extension-incubator on the classpath?", name), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeclarativeConfigException) {
                throw IncubatingUtil.toConfigurationException((DeclarativeConfigException)cause);
            }
            throw new ConfigurationException("Unexpected error configuring from " + name, e);
        }
    }

    private static ConfigurationException toConfigurationException(DeclarativeConfigException exception) {
        String message = Objects.requireNonNull(exception.getMessage());
        return new ConfigurationException(message, exception);
    }

    static void setGlobalConfigProvider(Object configProvider) {
        GlobalConfigProvider.set((ConfigProvider)configProvider);
    }

    static interface Factory {
        @Nullable
        public AutoConfiguredOpenTelemetrySdk create() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException;
    }
}

