/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;

class UnitConverter {
    private static final Map<String, UnitConverter> conversionMappings = new HashMap<String, UnitConverter>();
    private final Function<Number, Number> convertingFunction;

    @Nullable
    public static UnitConverter getInstance(@Nullable String sourceUnit, String targetUnit) {
        if (sourceUnit == null || sourceUnit.isEmpty() || targetUnit.isEmpty()) {
            return null;
        }
        String converterKey = UnitConverter.buildConverterKey(sourceUnit, targetUnit);
        UnitConverter converter = conversionMappings.get(converterKey);
        if (converter == null) {
            throw new IllegalArgumentException("Unsupported conversion from [" + sourceUnit + "] to [" + targetUnit + "]");
        }
        return converter;
    }

    static void registerConversion(String sourceUnit, String targetUnit, Function<Number, Number> convertingFunction) {
        if (sourceUnit.isEmpty()) {
            throw new IllegalArgumentException("Non empty sourceUnit must be provided");
        }
        if (targetUnit.isEmpty()) {
            throw new IllegalArgumentException("Non empty targetUnit must be provided");
        }
        String converterKey = UnitConverter.buildConverterKey(sourceUnit, targetUnit);
        if (conversionMappings.containsKey(converterKey)) {
            throw new IllegalArgumentException("Conversion from [" + sourceUnit + "] to [" + targetUnit + "] already defined");
        }
        conversionMappings.put(converterKey, new UnitConverter(convertingFunction));
    }

    private static String buildConverterKey(String sourceUnit, String targetUnit) {
        return sourceUnit + "->" + targetUnit;
    }

    UnitConverter(Function<Number, Number> convertingFunction) {
        this.convertingFunction = convertingFunction;
    }

    public Number convert(Number value) {
        return this.convertingFunction.apply(value);
    }

    static {
        UnitConverter.registerConversion("ms", "s", value -> value.doubleValue() / (double)TimeUnit.SECONDS.toMillis(1L));
        UnitConverter.registerConversion("us", "s", value -> value.doubleValue() / (double)TimeUnit.SECONDS.toMicros(1L));
        UnitConverter.registerConversion("ns", "s", value -> value.doubleValue() / (double)TimeUnit.SECONDS.toNanos(1L));
    }
}

