/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.instrumentation.jmx.engine.BeanAttributeExtractor;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public interface MetricAttributeExtractor {
    @Nullable
    public String extractValue(@Nullable MBeanServerConnection var1, @Nullable ObjectName var2);

    public static MetricAttributeExtractor fromConstant(String constantValue) {
        return (a, b) -> constantValue;
    }

    public static MetricAttributeExtractor fromObjectNameParameter(String parameterKey) {
        if (parameterKey.isEmpty()) {
            throw new IllegalArgumentException("Empty parameter name");
        }
        return (dummy, objectName) -> {
            if (objectName == null) {
                throw new IllegalArgumentException("Missing object name");
            }
            return objectName.getKeyProperty(parameterKey);
        };
    }

    public static MetricAttributeExtractor fromBeanAttribute(String attributeName) {
        return BeanAttributeExtractor.fromName(attributeName);
    }

    public static MetricAttributeExtractor toLowerCase(MetricAttributeExtractor extractor) {
        return (connection, objectName) -> {
            String value = extractor.extractValue(connection, objectName);
            if (value != null) {
                value = value.toLowerCase(Locale.ROOT);
            }
            return value;
        };
    }
}

