/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.rpc;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import javax.annotation.Nullable;

public final class RpcSizeAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    static final AttributeKey<Long> RPC_REQUEST_SIZE = AttributeKey.longKey("rpc.request.size");
    static final AttributeKey<Long> RPC_RESPONSE_SIZE = AttributeKey.longKey("rpc.response.size");
    private final RpcAttributesGetter<REQUEST> getter;

    RpcSizeAttributesExtractor(RpcAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    public static <REQUEST, RESPONSE> RpcSizeAttributesExtractor<REQUEST, RESPONSE> create(RpcAttributesGetter<REQUEST> attributesGetter) {
        return new RpcSizeAttributesExtractor<REQUEST, RESPONSE>(attributesGetter);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet(attributes, RPC_REQUEST_SIZE, this.getter.getRequestSize(request));
        AttributesExtractorUtil.internalSet(attributes, RPC_RESPONSE_SIZE, this.getter.getResponseSize(request));
    }
}

