/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.rpc;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.AutoValue_RpcServerMetrics_State;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcMetricsAdvice;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcSizeAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.internal.OperationMetricsUtil;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RpcServerMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> RPC_SERVER_REQUEST_METRICS_STATE = ContextKey.named("rpc-server-request-metrics-state");
    private static final Logger logger = Logger.getLogger(RpcServerMetrics.class.getName());
    private final DoubleHistogram serverDurationHistogram;
    private final LongHistogram serverRequestSize;
    private final LongHistogram serverResponseSize;

    private RpcServerMetrics(Meter meter) {
        DoubleHistogramBuilder durationBuilder = meter.histogramBuilder("rpc.server.duration").setDescription("The duration of an inbound RPC invocation.").setUnit("ms");
        RpcMetricsAdvice.applyServerDurationAdvice(durationBuilder);
        this.serverDurationHistogram = durationBuilder.build();
        LongHistogramBuilder requestSizeBuilder = meter.histogramBuilder("rpc.server.request.size").setUnit("By").setDescription("Measures the size of RPC request messages (uncompressed).").ofLongs();
        RpcMetricsAdvice.applyServerRequestSizeAdvice(requestSizeBuilder);
        this.serverRequestSize = requestSizeBuilder.build();
        LongHistogramBuilder responseSizeBuilder = meter.histogramBuilder("rpc.server.response.size").setUnit("By").setDescription("Measures the size of RPC response messages (uncompressed).").ofLongs();
        RpcMetricsAdvice.applyServerRequestSizeAdvice(responseSizeBuilder);
        this.serverResponseSize = responseSizeBuilder.build();
    }

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("rpc server", RpcServerMetrics::new);
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(RPC_SERVER_REQUEST_METRICS_STATE, new AutoValue_RpcServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long rpcServerResponseBodySize;
        State state = context.get(RPC_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record RPC request metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        this.serverDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, attributes, context);
        Long rpcServerRequestBodySize = attributes.get(RpcSizeAttributesExtractor.RPC_REQUEST_SIZE);
        if (rpcServerRequestBodySize != null) {
            this.serverRequestSize.record(rpcServerRequestBodySize, attributes, context);
        }
        if ((rpcServerResponseBodySize = attributes.get(RpcSizeAttributesExtractor.RPC_RESPONSE_SIZE)) != null) {
            this.serverResponseSize.record(rpcServerResponseBodySize, attributes, context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

