/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxscraper.config;

import io.opentelemetry.contrib.jmxscraper.JmxConnectorBuilder;
import io.opentelemetry.contrib.jmxscraper.config.JmxScraperConfig;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class PropertiesCustomizer
implements Function<ConfigProperties, Map<String, String>> {
    private static final Logger logger = Logger.getLogger(PropertiesCustomizer.class.getName());
    private static final String METRICS_EXPORTER = "otel.metrics.exporter";
    @Nullable
    private JmxScraperConfig scraperConfig;
    @Nullable
    private JmxConnectorBuilder connectorBuilder;

    @Override
    public Map<String, String> apply(ConfigProperties config) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (config.getList(METRICS_EXPORTER).isEmpty()) {
            result.put(METRICS_EXPORTER, "otlp");
        }
        long intervalLegacy = config.getLong("otel.jmx.interval.milliseconds", -1L);
        if (config.getDuration("otel.metric.export.interval") == null && intervalLegacy >= 0L) {
            logger.warning("otel.metric.export.interval deprecated option is used, replacing with 'otel.metric.export.interval' metric sdk configuration is recommended");
            result.put("otel.metric.export.interval", intervalLegacy + "ms");
        }
        this.scraperConfig = JmxScraperConfig.fromConfig(config);
        this.connectorBuilder = PropertiesCustomizer.createConnectorBuilder(this.scraperConfig);
        long exportSeconds = this.scraperConfig.getSamplingInterval().toMillis() / 1000L;
        logger.log(Level.INFO, "metrics export interval (seconds) =  " + exportSeconds);
        return result;
    }

    private static JmxConnectorBuilder createConnectorBuilder(JmxScraperConfig scraperConfig) {
        JmxConnectorBuilder connectorBuilder = JmxConnectorBuilder.createNew(scraperConfig.getServiceUrl());
        Optional.ofNullable(scraperConfig.getUsername()).ifPresent(connectorBuilder::withUser);
        Optional.ofNullable(scraperConfig.getPassword()).ifPresent(connectorBuilder::withPassword);
        if (scraperConfig.isRegistrySsl()) {
            connectorBuilder.withSslRegistry();
        }
        return connectorBuilder;
    }

    public JmxScraperConfig getScraperConfig() {
        if (this.scraperConfig == null) {
            throw new IllegalStateException("apply() must be called before getConfig()");
        }
        return this.scraperConfig;
    }

    public JmxConnectorBuilder getConnectorBuilder() {
        if (this.connectorBuilder == null) {
            throw new IllegalStateException("apply() must be called before getConnectorBuilder()");
        }
        return this.connectorBuilder;
    }
}

