/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxscraper;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;

public final class JmxConnectorBuilder {
    private static final Logger logger = Logger.getLogger(JmxConnectorBuilder.class.getName());
    private final JMXServiceURL url;
    @Nullable
    private String user;
    @Nullable
    private String password;
    @Nullable
    private String profile;
    @Nullable
    private String realm;
    private boolean sslRegistry;
    private static final SslRMIClientSocketFactory sslRmiClientSocketFactory = new SslRMIClientSocketFactory();

    private JmxConnectorBuilder(JMXServiceURL url) {
        this.url = url;
    }

    public static JmxConnectorBuilder createNew(String host, int port) {
        return new JmxConnectorBuilder(JmxConnectorBuilder.buildUrl(host, port));
    }

    public static JmxConnectorBuilder createNew(String url) {
        return new JmxConnectorBuilder(JmxConnectorBuilder.buildUrl(url));
    }

    @CanIgnoreReturnValue
    public JmxConnectorBuilder withUser(String user) {
        this.user = user;
        return this;
    }

    @CanIgnoreReturnValue
    public JmxConnectorBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    @CanIgnoreReturnValue
    public JmxConnectorBuilder withRemoteProfile(String profile) {
        this.profile = profile;
        return this;
    }

    @CanIgnoreReturnValue
    public JmxConnectorBuilder withRealm(String realm) {
        this.realm = realm;
        return this;
    }

    @CanIgnoreReturnValue
    public JmxConnectorBuilder withSslRegistry() {
        this.sslRegistry = true;
        return this;
    }

    public JMXConnector build() throws IOException {
        Map<String, Object> env = this.buildEnv();
        try {
            if (this.sslRegistry) {
                return this.doConnectSslRegistry(this.url, env);
            }
            return JmxConnectorBuilder.doConnect(this.url, env);
        }
        catch (IOException e) {
            throw new IOException("Unable to connect to " + this.url.getHost() + ":" + this.url.getPort(), e);
        }
    }

    private Map<String, Object> buildEnv() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.user != null && this.password != null) {
            env.put("jmx.remote.credentials", new String[]{this.user, this.password});
        }
        if (this.profile != null) {
            env.put("jmx.remote.profile", this.profile);
        }
        try {
            Class<?> klass = Class.forName("com.sun.security.sasl.Provider");
            Provider provider = (Provider)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Security.addProvider(provider);
            env.put("jmx.remote.sasl.callback.handler", callbacks -> {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(this.user);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        char[] pwd = this.password == null ? null : this.password.toCharArray();
                        ((PasswordCallback)callback).setPassword(pwd);
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        ((RealmCallback)callback).setText(this.realm);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            });
        }
        catch (ReflectiveOperationException e) {
            logger.log(Level.WARNING, "SASL unsupported in current environment: " + e.getMessage());
        }
        return env;
    }

    private static JMXConnector doConnect(JMXServiceURL url, Map<String, Object> env) throws IOException {
        logger.info("Connecting to " + url);
        return JMXConnectorFactory.connect(url, env);
    }

    public JMXConnector doConnectSslRegistry(JMXServiceURL url, Map<String, Object> env) {
        int port;
        String hostName;
        logger.info("Connecting with SSL protected RMI registry to " + url);
        if (url.getURLPath().startsWith("/jndi/")) {
            String[] components = url.getURLPath().split("/", 3);
            URI uri = URI.create(components[2]);
            hostName = uri.getHost();
            port = uri.getPort();
        } else {
            hostName = url.getHost();
            port = url.getPort();
        }
        try {
            RMIConnector jmxConn = new RMIConnector(JmxConnectorBuilder.getStub(hostName, port), null);
            jmxConn.connect(env);
            return jmxConn;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to connect to " + url, e);
        }
    }

    private static JMXServiceURL buildUrl(String host, int port) {
        return JmxConnectorBuilder.buildUrl(String.format(Locale.getDefault(), "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", host, port));
    }

    private static JMXServiceURL buildUrl(String url) {
        try {
            return new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid url", e);
        }
    }

    private static RMIServer getStub(String hostName, int port) throws IOException {
        try {
            Registry registry = LocateRegistry.getRegistry(hostName, port, sslRmiClientSocketFactory);
            return (RMIServer)registry.lookup("jmxrmi");
        }
        catch (NotBoundException nbe) {
            throw new IOException(nbe);
        }
    }
}

