/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.jmx.engine.MetricAttribute;
import io.opentelemetry.instrumentation.jmx.engine.MetricAttributeExtractor;
import io.opentelemetry.instrumentation.jmx.engine.MetricInfo;
import io.opentelemetry.instrumentation.jmx.yaml.StateMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class MetricStructure {
    private Map<String, Object> metricAttribute;
    private StateMapping stateMapping = StateMapping.empty();
    private static final String STATE_MAPPING_DEFAULT = "*";
    @Nullable
    private String sourceUnit;
    @Nullable
    private String unit;
    @Nullable
    private Boolean dropNegativeValues;
    private MetricInfo.Type metricType;
    private List<MetricAttribute> metricAttributes;

    MetricStructure() {
    }

    void setType(String t) {
        t = t.trim().toUpperCase(Locale.ROOT);
        try {
            this.metricType = MetricInfo.Type.valueOf(t);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid metric type: " + t, e);
        }
    }

    @Nullable
    public String getSourceUnit() {
        return this.sourceUnit;
    }

    public void setSourceUnit(String unit) {
        this.sourceUnit = this.validateUnit(unit.trim());
    }

    @Nullable
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit.trim();
    }

    public void setDropNegativeValues(Boolean dropNegativeValues) {
        this.dropNegativeValues = dropNegativeValues;
    }

    @Nullable
    public Boolean getDropNegativeValues() {
        return this.dropNegativeValues;
    }

    private static void addMappedValue(StateMapping.Builder builder, String stateValue, String stateKey) {
        if (stateValue.equals(STATE_MAPPING_DEFAULT)) {
            builder.withDefaultState(stateKey);
        } else {
            builder.withMappedValue(stateValue, stateKey);
        }
    }

    @CanIgnoreReturnValue
    private String validateUnit(String unit) {
        this.requireNonEmpty(unit, "Metric unit is empty");
        return unit;
    }

    public void setMetricAttribute(Map<String, Object> map) {
        this.metricAttribute = map;
        this.metricAttributes = this.addMetricAttributes(map);
    }

    public Map<String, Object> getMetricAttribute() {
        return this.metricAttribute;
    }

    public MetricInfo.Type getMetricType() {
        return this.metricType;
    }

    protected List<MetricAttribute> getAttributeList() {
        return this.metricAttributes;
    }

    protected void requireNonEmpty(String s, String msg) {
        if (s.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
    }

    private List<MetricAttribute> addMetricAttributes(Map<String, Object> metricAttributeMap) {
        ArrayList<MetricAttribute> list = new ArrayList<MetricAttribute>();
        for (String key : metricAttributeMap.keySet()) {
            MetricAttribute attribute;
            Object value = metricAttributeMap.get(key);
            if (value == null) {
                throw new IllegalStateException("nothing specified for metric attribute key '" + key + "'");
            }
            if (value instanceof String) {
                attribute = MetricStructure.buildMetricAttribute(key, ((String)value).trim());
            } else if (value instanceof Map) {
                attribute = this.buildStateMetricAttribute(key, (Map)value);
            } else {
                throw new IllegalArgumentException("unexpected metric attribute: " + value);
            }
            list.add(attribute);
        }
        return list;
    }

    static MetricAttribute buildMetricAttribute(String key, String target) {
        String constantValue;
        String attributeName;
        String errorMsg = String.format("Invalid metric attribute expression for '%s' : '%s'", key, target);
        String targetExpr = target;
        boolean lowercase = false;
        String lowerCaseExpr = MetricStructure.tryParseFunction("lowercase", targetExpr, errorMsg);
        if (lowerCaseExpr != null) {
            lowercase = true;
            targetExpr = lowerCaseExpr;
        }
        MetricAttributeExtractor extractor = null;
        String paramName = MetricStructure.tryParseFunction("param", targetExpr, errorMsg);
        if (paramName != null) {
            extractor = MetricAttributeExtractor.fromObjectNameParameter(paramName);
        }
        if (extractor == null && (attributeName = MetricStructure.tryParseFunction("beanattr", targetExpr, errorMsg)) != null) {
            extractor = MetricAttributeExtractor.fromBeanAttribute(attributeName);
        }
        if (extractor == null && (constantValue = MetricStructure.tryParseFunction("const", targetExpr, errorMsg)) != null) {
            extractor = MetricAttributeExtractor.fromConstant(constantValue);
        }
        if (extractor == null) {
            throw new IllegalArgumentException(errorMsg);
        }
        if (lowercase) {
            extractor = MetricAttributeExtractor.toLowerCase(extractor);
        }
        return new MetricAttribute(key, extractor);
    }

    private static String tryParseFunction(String function, String expression, String errorMsg) {
        if (!expression.startsWith(function)) {
            return null;
        }
        String expr = expression.substring(function.length()).trim();
        if (expr.charAt(0) != '(' || expr.charAt(expr.length() - 1) != ')') {
            throw new IllegalArgumentException(errorMsg);
        }
        if ((expr = expr.substring(1, expr.length() - 1).trim()).isEmpty()) {
            throw new IllegalArgumentException(errorMsg);
        }
        return expr.trim();
    }

    private MetricAttribute buildStateMetricAttribute(String key, Map<?, ?> stateMap) {
        if (stateMap.isEmpty()) {
            throw new IllegalArgumentException("state map is empty for key " + key);
        }
        if (!this.stateMapping.isEmpty()) {
            throw new IllegalStateException("only a single state map is expected");
        }
        StateMapping.Builder builder = StateMapping.builder();
        for (Map.Entry<?, ?> entry : stateMap.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("unexpected state map key: " + entry.getKey());
            }
            String stateKey = (String)entry.getKey();
            Object objValue = entry.getValue();
            if (objValue instanceof String) {
                MetricStructure.addMappedValue(builder, (String)objValue, stateKey);
                continue;
            }
            if (!(objValue instanceof List)) continue;
            for (Object listEntry : (List)objValue) {
                if (!(listEntry instanceof String)) {
                    throw new IllegalArgumentException("unexpected state list value: " + stateKey);
                }
                MetricStructure.addMappedValue(builder, (String)listEntry, stateKey);
            }
        }
        this.stateMapping = builder.build();
        return new MetricAttribute(key, null);
    }

    public StateMapping getStateMapping() {
        return this.stateMapping;
    }
}

