/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.common.KeyValue;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import io.opentelemetry.proto.common.v1.internal.KeyValueList;
import java.io.IOException;
import java.util.List;

final class KeyValueListAnyValueMarshaler
extends MarshalerWithSize {
    private final Marshaler value;

    KeyValueListAnyValueMarshaler(KeyValueListMarshaler value) {
        super(KeyValueListAnyValueMarshaler.calculateSize(value));
        this.value = value;
    }

    static MarshalerWithSize create(List<KeyValue> values2) {
        int len = values2.size();
        KeyValueMarshaler[] marshalers = new KeyValueMarshaler[values2.size()];
        for (int i = 0; i < len; ++i) {
            marshalers[i] = KeyValueMarshaler.createForKeyValue(values2.get(i));
        }
        return new KeyValueListAnyValueMarshaler(new KeyValueListMarshaler(marshalers));
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(AnyValue.KVLIST_VALUE, this.value);
    }

    private static int calculateSize(Marshaler value) {
        return MarshalerUtil.sizeMessage(AnyValue.KVLIST_VALUE, value);
    }

    static class KeyValueListMarshaler
    extends MarshalerWithSize {
        private final Marshaler[] values;

        KeyValueListMarshaler(KeyValueMarshaler[] values2) {
            super(KeyValueListMarshaler.calculateSize(values2));
            this.values = values2;
        }

        @Override
        public void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(KeyValueList.VALUES, this.values);
        }

        private static int calculateSize(Marshaler[] values2) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)KeyValueList.VALUES, (Marshaler[])values2);
        }
    }
}

