/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.config;

import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class DeclarativeConfigPropertyUtil {
    private static final List<BiFunction<String, DeclarativeConfigProperties, Object>> valueResolvers = Arrays.asList(DeclarativeConfigPropertyUtil::getString, DeclarativeConfigPropertyUtil::getBoolean, DeclarativeConfigPropertyUtil::getLong, DeclarativeConfigPropertyUtil::getDouble, DeclarativeConfigPropertyUtil::getStringList, DeclarativeConfigPropertyUtil::getBooleanList, DeclarativeConfigPropertyUtil::getLongList, DeclarativeConfigPropertyUtil::getDoubleList, DeclarativeConfigPropertyUtil::getStringList, DeclarativeConfigPropertyUtil::getStructuredList, DeclarativeConfigPropertyUtil::getStructured);

    private DeclarativeConfigPropertyUtil() {
    }

    static Map<String, Object> toMap(DeclarativeConfigProperties declarativeConfigProperties) {
        Set<String> propertyKeys = declarativeConfigProperties.getPropertyKeys();
        HashMap<String, Object> result2 = new HashMap<String, Object>(propertyKeys.size());
        for (String key : declarativeConfigProperties.getPropertyKeys()) {
            result2.put(key, DeclarativeConfigPropertyUtil.resolveValue(key, declarativeConfigProperties));
        }
        return result2;
    }

    @Nullable
    private static Object resolveValue(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        for (int i = 0; i < valueResolvers.size(); ++i) {
            try {
                Object value = valueResolvers.get(i).apply(key, declarativeConfigProperties);
                if (value == null) continue;
                return value;
            }
            catch (DeclarativeConfigException declarativeConfigException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Object getString(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return declarativeConfigProperties.getString(key);
    }

    @Nullable
    private static Object getBoolean(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return declarativeConfigProperties.getBoolean(key);
    }

    @Nullable
    private static Object getLong(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return declarativeConfigProperties.getLong(key);
    }

    @Nullable
    private static Object getDouble(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return declarativeConfigProperties.getDouble(key);
    }

    @Nullable
    private static Object getStringList(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return declarativeConfigProperties.getScalarList(key, String.class);
    }

    @Nullable
    private static Object getBooleanList(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return declarativeConfigProperties.getScalarList(key, Boolean.class);
    }

    @Nullable
    private static Object getLongList(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return declarativeConfigProperties.getScalarList(key, Long.class);
    }

    @Nullable
    private static Object getDoubleList(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return declarativeConfigProperties.getScalarList(key, Double.class);
    }

    @Nullable
    private static Object getStructuredList(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return Optional.ofNullable(declarativeConfigProperties.getStructuredList(key)).map(list -> list.stream().map(DeclarativeConfigPropertyUtil::toMap).collect(Collectors.toList())).orElse(null);
    }

    @Nullable
    private static Object getStructured(String key, DeclarativeConfigProperties declarativeConfigProperties) {
        return Optional.ofNullable(declarativeConfigProperties.getStructured(key)).map(DeclarativeConfigPropertyUtil::toMap).orElse(null);
    }
}

