/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.jmx.engine.MetricInfo;
import io.opentelemetry.instrumentation.jmx.yaml.JmxRule;
import io.opentelemetry.instrumentation.jmx.yaml.MetricStructure;
import javax.annotation.Nullable;

public class Metric
extends MetricStructure {
    @Nullable
    private String metric;
    @Nullable
    private String desc;

    @Nullable
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = this.validateMetricName(metric.trim());
    }

    @CanIgnoreReturnValue
    private String validateMetricName(String name) {
        this.requireNonEmpty(name, "The metric name is empty");
        return name;
    }

    @Nullable
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc.trim();
    }

    MetricInfo buildMetricInfo(String attributeName, JmxRule parentJmxRule) {
        String unit;
        String sourceUnit;
        String prefix = parentJmxRule.getPrefix();
        String metricName = this.metric == null ? (prefix == null ? attributeName : prefix + attributeName) : (prefix == null ? this.metric : prefix + this.metric);
        MetricInfo.Type metricType = this.getMetricType();
        if (metricType == null) {
            metricType = parentJmxRule.getMetricType();
        }
        if (metricType == null) {
            metricType = MetricInfo.Type.GAUGE;
        }
        if ((sourceUnit = this.getSourceUnit()) == null) {
            sourceUnit = parentJmxRule.getSourceUnit();
        }
        if (!this.getStateMapping().isEmpty()) {
            unit = "";
        } else {
            unit = this.getUnit();
            if (unit == null) {
                unit = parentJmxRule.getUnit();
            }
            if (unit == null) {
                throw new IllegalStateException(String.format("Metric unit is required for metric '%s'", metricName));
            }
        }
        return new MetricInfo(metricName, this.desc, sourceUnit, unit, metricType);
    }
}

