/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.jmx.engine.BeanFinder;
import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.engine.MetricRegistrar;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;

public class JmxMetricInsight {
    private static final Logger logger = Logger.getLogger(JmxMetricInsight.class.getName());
    private static final String INSTRUMENTATION_SCOPE = "io.opentelemetry.jmx";
    private final OpenTelemetry openTelemetry;
    private final long discoveryDelay;

    public static JmxMetricInsight createService(OpenTelemetry ot, long discoveryDelay) {
        return new JmxMetricInsight(ot, discoveryDelay);
    }

    public static Logger getLogger() {
        return logger;
    }

    private JmxMetricInsight(OpenTelemetry openTelemetry, long discoveryDelay) {
        this.openTelemetry = openTelemetry;
        this.discoveryDelay = discoveryDelay;
    }

    public void startLocal(MetricConfiguration conf) {
        this.start(conf, () -> MBeanServerFactory.findMBeanServer(null));
    }

    public void startRemote(MetricConfiguration conf, Supplier<List<? extends MBeanServerConnection>> connections) {
        this.start(conf, connections);
    }

    private void start(MetricConfiguration conf, Supplier<List<? extends MBeanServerConnection>> connections) {
        if (conf.isEmpty()) {
            logger.log(Level.FINE, "Empty JMX configuration, no metrics will be collected for InstrumentationScope io.opentelemetry.jmx");
        } else {
            MetricRegistrar registrar = new MetricRegistrar(this.openTelemetry, INSTRUMENTATION_SCOPE);
            BeanFinder finder = new BeanFinder(registrar, this.discoveryDelay);
            finder.discoverBeans(conf, connections);
        }
    }
}

