/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxscraper;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.contrib.jmxscraper.InvalidArgumentException;
import io.opentelemetry.contrib.jmxscraper.JmxConnectorBuilder;
import io.opentelemetry.contrib.jmxscraper.config.JmxScraperConfig;
import io.opentelemetry.contrib.jmxscraper.config.PropertiesCustomizer;
import io.opentelemetry.contrib.jmxscraper.config.PropertiesSupplier;
import io.opentelemetry.instrumentation.jmx.engine.JmxMetricInsight;
import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.yaml.RuleParser;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;

public class JmxScraper {
    private static final Logger logger = Logger.getLogger(JmxScraper.class.getName());
    private static final String CONFIG_ARG = "-config";
    private static final String TEST_ARG = "-test";
    private final JmxConnectorBuilder client;
    private final JmxMetricInsight service;
    private final JmxScraperConfig config;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public static void main(String[] args2) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %4$s %5$s%n");
        ArrayList<String> effectiveArgs = new ArrayList<String>(Arrays.asList(args2));
        boolean testMode = effectiveArgs.remove(TEST_ARG);
        try {
            Properties argsConfig = JmxScraper.argsToConfig(effectiveArgs);
            JmxScraper.propagateToSystemProperties(argsConfig);
            PropertiesCustomizer configCustomizer = new PropertiesCustomizer();
            ((AutoConfiguredOpenTelemetrySdkBuilder)((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier((Supplier)new PropertiesSupplier(argsConfig))).addPropertiesCustomizer((Function)configCustomizer)).setResultAsGlobal().build();
            JmxScraperConfig scraperConfig = configCustomizer.getScraperConfig();
            long exportSeconds = scraperConfig.getSamplingInterval().toMillis() / 1000L;
            logger.log(Level.INFO, "metrics export interval (seconds) =  " + exportSeconds);
            JmxMetricInsight service = JmxMetricInsight.createService(GlobalOpenTelemetry.get(), scraperConfig.getSamplingInterval().toMillis());
            JmxConnectorBuilder connectorBuilder = JmxConnectorBuilder.createNew(scraperConfig.getServiceUrl());
            Optional.ofNullable(scraperConfig.getUsername()).ifPresent(connectorBuilder::withUser);
            Optional.ofNullable(scraperConfig.getPassword()).ifPresent(connectorBuilder::withPassword);
            if (scraperConfig.isRegistrySsl()) {
                connectorBuilder.withSslRegistry();
            }
            if (testMode) {
                System.exit(JmxScraper.testConnection(connectorBuilder) ? 0 : 1);
            } else {
                JmxScraper jmxScraper = new JmxScraper(connectorBuilder, service, scraperConfig);
                jmxScraper.start();
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.SEVERE, "invalid configuration ", e);
            System.exit(1);
        }
        catch (InvalidArgumentException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            logger.info("Usage: java -jar <path_to_jmxscraper.jar> [-test] [-config <conf>]");
            logger.info("  -test           test JMX connection with provided configuration and exit");
            logger.info("  -config <conf>  provide configuration, where <conf> is - for stdin, or <path_to_config.properties>");
            System.exit(1);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to connect ", e);
            System.exit(2);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean testConnection(JmxConnectorBuilder connectorBuilder) {
        try (JMXConnector connector = connectorBuilder.build();){
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            Integer mbeanCount = connection.getMBeanCount();
            if (mbeanCount > 0) {
                logger.log(Level.INFO, "JMX connection test OK");
                boolean bl2 = true;
                return bl2;
            }
            logger.log(Level.SEVERE, "JMX connection test ERROR");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "JMX connection test ERROR", e);
            return false;
        }
    }

    static void propagateToSystemProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!key.startsWith("javax.net.ssl.keyStore") && !key.startsWith("javax.net.ssl.trustStore") || System.getProperty(key) != null) continue;
            System.setProperty(key, value);
        }
    }

    static Properties argsToConfig(List<String> args2) throws InvalidArgumentException {
        if (args2.isEmpty()) {
            return new Properties();
        }
        if (args2.size() != 2) {
            throw new InvalidArgumentException("Unexpected number of arguments");
        }
        if (!args2.get(0).equalsIgnoreCase(CONFIG_ARG)) {
            throw new InvalidArgumentException("Unexpected argument must be '-config'");
        }
        String path = args2.get(1);
        if (path.trim().equals("-")) {
            return JmxScraper.loadPropertiesFromStdin();
        }
        return JmxScraper.loadPropertiesFromPath(path);
    }

    private static Properties loadPropertiesFromStdin() throws InvalidArgumentException {
        Properties properties;
        Properties properties2 = new Properties();
        DataInputStream is = new DataInputStream(System.in);
        try {
            properties2.load(is);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidArgumentException("Failed to read config properties from stdin", e);
            }
        }
        ((InputStream)is).close();
        return properties;
    }

    private static Properties loadPropertiesFromPath(String path) throws InvalidArgumentException {
        Properties properties;
        block8: {
            Properties properties2 = new Properties();
            InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            try {
                properties2.load(is);
                properties = properties2;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidArgumentException("Failed to read config from file: '" + path + "'", e);
                }
            }
            is.close();
        }
        return properties;
    }

    private JmxScraper(JmxConnectorBuilder client, JmxMetricInsight service, JmxScraperConfig config) {
        this.client = client;
        this.service = service;
        this.config = config;
    }

    private void start() throws IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("JMX scraping stopped");
            this.running.set(false);
        }));
        try (JMXConnector connector = this.client.build();){
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            this.service.startRemote(JmxScraper.getMetricConfig(this.config), () -> Collections.singletonList(connection));
            this.running.set(true);
            logger.info("JMX scraping started");
            while (this.running.get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static MetricConfiguration getMetricConfig(JmxScraperConfig scraperConfig) {
        MetricConfiguration config = new MetricConfiguration();
        for (String system : scraperConfig.getTargetSystems()) {
            try {
                InputStream yaml = scraperConfig.getTargetSystemYaml(system);
                try {
                    RuleParser.get().addMetricDefsTo(config, yaml, system);
                }
                finally {
                    if (yaml == null) continue;
                    yaml.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while loading rules for system " + system, e);
            }
        }
        for (String file : scraperConfig.getJmxConfig()) {
            JmxScraper.addRulesFromFile(file, config);
        }
        return config;
    }

    private static void addRulesFromFile(String file, MetricConfiguration conf) {
        Path path = Paths.get(file, new String[0]);
        if (!Files.isReadable(path)) {
            throw new IllegalArgumentException("Unable to read file: " + path);
        }
        try (InputStream inputStream2 = Files.newInputStream(path, new OpenOption[0]);){
            RuleParser.get().addMetricDefsTo(conf, inputStream2, file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while loading rules from file: " + file, e);
        }
    }
}

