/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.jmx.engine.MetricInfo;
import io.opentelemetry.instrumentation.jmx.yaml.MetricStructure;
import javax.annotation.Nullable;

public class Metric
extends MetricStructure {
    @Nullable
    private String metric;
    @Nullable
    private String desc;

    @Nullable
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = this.validateMetricName(metric.trim());
    }

    @CanIgnoreReturnValue
    private String validateMetricName(String name) {
        this.requireNonEmpty(name, "The metric name is empty");
        return name;
    }

    @Nullable
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc.trim();
    }

    MetricInfo buildMetricInfo(@Nullable String prefix, String attributeName, String defaultSourceUnit, String defaultUnit, MetricInfo.Type defaultType) {
        String unit;
        String sourceUnit;
        String metricName = this.metric == null ? (prefix == null ? attributeName : prefix + attributeName) : (prefix == null ? this.metric : prefix + this.metric);
        MetricInfo.Type metricType = this.getMetricType();
        if (metricType == null) {
            metricType = defaultType;
        }
        if ((sourceUnit = this.getSourceUnit()) == null) {
            sourceUnit = defaultSourceUnit;
        }
        if ((unit = this.getUnit()) == null) {
            unit = defaultUnit;
        }
        return new MetricInfo(metricName, this.desc, sourceUnit, unit, metricType);
    }
}

