/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxscraper.config;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class JmxScraperConfig {
    private static final Logger logger = Logger.getLogger(JmxScraperConfig.class.getName());
    static final String METRIC_EXPORT_INTERVAL = "otel.metric.export.interval";
    static final String JMX_INTERVAL_LEGACY = "otel.jmx.interval.milliseconds";
    static final String JMX_SERVICE_URL = "otel.jmx.service.url";
    static final String JMX_CONFIG = "otel.jmx.config";
    static final String JMX_CONFIG_LEGACY = "otel.jmx.custom.scraping.config";
    static final String JMX_TARGET_SYSTEM = "otel.jmx.target.system";
    static final String JMX_TARGET_SOURCE = "otel.jmx.target.source";
    static final String JMX_USERNAME = "otel.jmx.username";
    static final String JMX_PASSWORD = "otel.jmx.password";
    static final String JMX_REGISTRY_SSL = "otel.jmx.remote.registry.ssl";
    static final String JMX_REMOTE_PROFILE = "otel.jmx.remote.profile";
    static final String JMX_REALM = "otel.jmx.realm";
    private String serviceUrl = "";
    private List<String> jmxConfig = Collections.emptyList();
    private Set<String> targetSystems = Collections.emptySet();
    private TargetSystemSource targetSystemSource = TargetSystemSource.AUTO;
    private Duration samplingInterval = Duration.ofMinutes(1L);
    @Nullable
    private String username;
    @Nullable
    private String password;
    @Nullable
    private String realm;
    @Nullable
    private String remoteProfile;
    private boolean registrySsl;

    private JmxScraperConfig() {
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public List<String> getJmxConfig() {
        return this.jmxConfig;
    }

    public Set<String> getTargetSystems() {
        return this.targetSystems;
    }

    public InputStream getTargetSystemYaml(String system) {
        InputStream yaml;
        switch (this.targetSystemSource) {
            case LEGACY: {
                yaml = JmxScraperConfig.getTargetSystemYaml(system, TargetSystemSource.LEGACY);
                break;
            }
            case INSTRUMENTATION: {
                yaml = JmxScraperConfig.getTargetSystemYaml(system, TargetSystemSource.INSTRUMENTATION);
                break;
            }
            case AUTO: {
                yaml = JmxScraperConfig.getTargetSystemYaml(system, TargetSystemSource.INSTRUMENTATION);
                if (yaml != null) break;
                yaml = JmxScraperConfig.getTargetSystemYaml(system, TargetSystemSource.LEGACY);
                break;
            }
            default: {
                throw new IllegalStateException("unsupported target system source: " + (Object)((Object)this.targetSystemSource));
            }
        }
        if (yaml == null) {
            throw new ConfigurationException("unsupported target system: '" + system + "', source: " + (Object)((Object)this.targetSystemSource));
        }
        return yaml;
    }

    @Nullable
    private static InputStream getTargetSystemYaml(String system, TargetSystemSource source2) {
        String path;
        switch (source2) {
            case LEGACY: {
                path = String.format("%s.yaml", system);
                break;
            }
            case INSTRUMENTATION: {
                path = String.format("jmx/rules/%s.yaml", system);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid source" + (Object)((Object)source2));
            }
        }
        return JmxScraperConfig.class.getClassLoader().getResourceAsStream(path);
    }

    public Duration getSamplingInterval() {
        return this.samplingInterval;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getRealm() {
        return this.realm;
    }

    @Nullable
    public String getRemoteProfile() {
        return this.remoteProfile;
    }

    public boolean isRegistrySsl() {
        return this.registrySsl;
    }

    public static JmxScraperConfig fromConfig(ConfigProperties config) {
        JmxScraperConfig scraperConfig = new JmxScraperConfig();
        Duration exportInterval = config.getDuration(METRIC_EXPORT_INTERVAL);
        scraperConfig.samplingInterval = exportInterval == null || exportInterval.isNegative() || exportInterval.isZero() ? Duration.ofMinutes(1L) : exportInterval;
        String serviceUrl = config.getString(JMX_SERVICE_URL);
        if (serviceUrl == null) {
            throw new ConfigurationException("missing mandatory otel.jmx.service.url");
        }
        scraperConfig.serviceUrl = serviceUrl;
        List<String> jmxConfig = config.getList(JMX_CONFIG);
        List<String> targetSystem = config.getList(JMX_TARGET_SYSTEM);
        String jmxConfigDeprecated = config.getString(JMX_CONFIG_LEGACY);
        if (jmxConfigDeprecated != null) {
            logger.warning("otel.jmx.custom.scraping.config deprecated option is used, replacing with 'otel.jmx.config' is recommended");
            ArrayList<String> list = new ArrayList<String>(jmxConfig);
            list.add(jmxConfigDeprecated);
            jmxConfig = list;
        }
        if (targetSystem.isEmpty() && jmxConfig.isEmpty()) {
            throw new ConfigurationException("at least one of 'otel.jmx.target.system' or 'otel.jmx.config' must be set");
        }
        scraperConfig.jmxConfig = Collections.unmodifiableList(jmxConfig);
        scraperConfig.targetSystems = Collections.unmodifiableSet(new HashSet<String>(targetSystem));
        scraperConfig.username = config.getString(JMX_USERNAME);
        scraperConfig.password = config.getString(JMX_PASSWORD);
        scraperConfig.remoteProfile = config.getString(JMX_REMOTE_PROFILE);
        scraperConfig.realm = config.getString(JMX_REALM);
        scraperConfig.registrySsl = config.getBoolean(JMX_REGISTRY_SSL, false);
        scraperConfig.targetSystems.forEach(scraperConfig::getTargetSystemYaml);
        String source2 = config.getString(JMX_TARGET_SOURCE, TargetSystemSource.AUTO.name());
        scraperConfig.targetSystemSource = TargetSystemSource.fromString(source2);
        return scraperConfig;
    }

    public static enum TargetSystemSource {
        AUTO,
        INSTRUMENTATION,
        LEGACY;


        static TargetSystemSource fromString(String source2) {
            try {
                return TargetSystemSource.valueOf(source2.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid target system source: " + source2, e);
            }
        }
    }
}

