/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class StateMapping {
    private static final StateMapping EMPTY = new StateMapping(null, Collections.emptyMap(), Collections.emptySet());
    @Nullable
    private final String defaultStateKey;
    private final Map<String, String> stateMapping;
    private final Set<String> stateKeys;

    private StateMapping(@Nullable String defaultState, Map<String, String> stateMapping, Set<String> stateKeys) {
        this.defaultStateKey = defaultState;
        this.stateMapping = stateMapping;
        this.stateKeys = stateKeys;
    }

    public boolean isEmpty() {
        return this.stateKeys.isEmpty();
    }

    public Set<String> getStateKeys() {
        return this.stateKeys;
    }

    @Nullable
    public String getDefaultStateKey() {
        return this.defaultStateKey;
    }

    @Nullable
    public String getStateValue(String rawValue) {
        String value = this.stateMapping.get(rawValue);
        if (value == null) {
            value = this.defaultStateKey;
        }
        return value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StateMapping empty() {
        return EMPTY;
    }

    public static class Builder {
        private String defaultState;
        private final Map<String, String> valueMapping = new HashMap<String, String>();
        private final Set<String> stateKeys = new HashSet<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder withDefaultState(String state) {
            if (this.defaultState != null) {
                throw new IllegalStateException("default state already set");
            }
            this.defaultState = state;
            this.stateKeys.add(this.defaultState);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withMappedValue(String value, String state) {
            String currentMapping = this.valueMapping.putIfAbsent(value, state);
            if (currentMapping != null) {
                throw new IllegalStateException(value + " already mapped to " + currentMapping);
            }
            this.stateKeys.add(state);
            return this;
        }

        StateMapping build() {
            if (this.stateKeys.isEmpty()) {
                return EMPTY;
            }
            if (this.defaultState == null) {
                throw new IllegalStateException("missing default state");
            }
            return new StateMapping(this.defaultState, this.valueMapping, this.stateKeys);
        }
    }
}

