/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.instrumentation.jmx.engine.BeanAttributeExtractor;
import javax.annotation.Nullable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public interface MetricAttributeExtractor {
    @Nullable
    public String extractValue(@Nullable MBeanServerConnection var1, @Nullable ObjectName var2);

    public static MetricAttributeExtractor fromConstant(String constantValue) {
        return (a, b) -> constantValue;
    }

    public static MetricAttributeExtractor fromObjectNameParameter(String parameterKey) {
        if (parameterKey.isEmpty()) {
            throw new IllegalArgumentException("Empty parameter name");
        }
        return (dummy, objectName) -> objectName.getKeyProperty(parameterKey);
    }

    public static MetricAttributeExtractor fromBeanAttribute(String attributeName) {
        return BeanAttributeExtractor.fromName(attributeName);
    }
}

