/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxscraper.config;

import io.opentelemetry.contrib.jmxscraper.config.ConfigurationException;
import io.opentelemetry.contrib.jmxscraper.internal.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class JmxScraperConfig {
    static final String SERVICE_URL = "otel.jmx.service.url";
    static final String CUSTOM_JMX_SCRAPING_CONFIG = "otel.jmx.custom.scraping.config";
    static final String TARGET_SYSTEM = "otel.jmx.target.system";
    static final String INTERVAL_MILLISECONDS = "otel.jmx.interval.milliseconds";
    static final String METRICS_EXPORTER_TYPE = "otel.metrics.exporter";
    static final String EXPORTER_INTERVAL = "otel.metric.export.interval";
    static final String REGISTRY_SSL = "otel.jmx.remote.registry.ssl";
    static final String OTLP_ENDPOINT = "otel.exporter.otlp.endpoint";
    static final String JMX_USERNAME = "otel.jmx.username";
    static final String JMX_PASSWORD = "otel.jmx.password";
    static final String JMX_REMOTE_PROFILE = "otel.jmx.remote.profile";
    static final String JMX_REALM = "otel.jmx.realm";
    static final String OTLP_METRICS_EXPORTER = "otlp";
    static final List<String> AVAILABLE_TARGET_SYSTEMS = Collections.unmodifiableList(Arrays.asList("activemq", "cassandra", "hbase", "hadoop", "jetty", "jvm", "kafka", "kafka-consumer", "kafka-producer", "solr", "tomcat", "wildfly"));
    private String serviceUrl = "";
    private String customJmxScrapingConfigPath = "";
    private Set<String> targetSystems = Collections.emptySet();
    private int intervalMilliseconds;
    private String metricsExporterType = "";
    private String otlpExporterEndpoint = "";
    private String username = "";
    private String password = "";
    private String realm = "";
    private String remoteProfile = "";
    private boolean registrySsl;
    private final Properties properties;

    private JmxScraperConfig(Properties properties) {
        this.properties = properties;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getCustomJmxScrapingConfigPath() {
        return this.customJmxScrapingConfigPath;
    }

    public Set<String> getTargetSystems() {
        return this.targetSystems;
    }

    public int getIntervalMilliseconds() {
        return this.intervalMilliseconds;
    }

    public String getMetricsExporterType() {
        return this.metricsExporterType;
    }

    public String getOtlpExporterEndpoint() {
        return this.otlpExporterEndpoint;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getRemoteProfile() {
        return this.remoteProfile;
    }

    public boolean isRegistrySsl() {
        return this.registrySsl;
    }

    public static JmxScraperConfig fromProperties(Properties userProperties, Properties systemProperties) throws ConfigurationException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)userProperties);
        properties.putAll((Map<?, ?>)systemProperties);
        JmxScraperConfig config = new JmxScraperConfig(properties);
        config.serviceUrl = properties.getProperty(SERVICE_URL);
        config.customJmxScrapingConfigPath = properties.getProperty(CUSTOM_JMX_SCRAPING_CONFIG);
        String targetSystem = properties.getProperty(TARGET_SYSTEM, "").toLowerCase(Locale.ENGLISH).trim();
        List<String> targets = Arrays.asList(StringUtils.isBlank(targetSystem) ? new String[]{} : targetSystem.split(","));
        config.targetSystems = targets.stream().map(String::trim).collect(Collectors.toSet());
        int interval = JmxScraperConfig.getProperty(properties, INTERVAL_MILLISECONDS, 0);
        config.intervalMilliseconds = interval == 0 ? 10000 : interval;
        JmxScraperConfig.getAndSetPropertyIfUndefined(properties, EXPORTER_INTERVAL, config.intervalMilliseconds);
        config.metricsExporterType = JmxScraperConfig.getAndSetPropertyIfUndefined(properties, METRICS_EXPORTER_TYPE, "logging");
        if (OTLP_METRICS_EXPORTER.equalsIgnoreCase(config.metricsExporterType)) {
            config.otlpExporterEndpoint = JmxScraperConfig.getAndSetPropertyIfUndefined(properties, OTLP_ENDPOINT, "http://localhost:4318");
        }
        config.username = properties.getProperty(JMX_USERNAME);
        config.password = properties.getProperty(JMX_PASSWORD);
        config.remoteProfile = properties.getProperty(JMX_REMOTE_PROFILE);
        config.realm = properties.getProperty(JMX_REALM);
        config.registrySsl = Boolean.parseBoolean(properties.getProperty(REGISTRY_SSL));
        JmxScraperConfig.validateConfig(config);
        return config;
    }

    public void propagateSystemProperties() {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!key.startsWith("otel.") && !key.startsWith("javax.net.ssl.keyStore") && !key.startsWith("javax.net.ssl.trustStore")) continue;
            System.setProperty(key, value);
        }
    }

    private static int getProperty(Properties properties, String key, int defaultValue) throws ConfigurationException {
        String propVal = properties.getProperty(key);
        if (propVal == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propVal);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Failed to parse " + key, e);
        }
    }

    private static String getAndSetPropertyIfUndefined(Properties properties, String key, String defaultValue) {
        String propVal = properties.getProperty(key, defaultValue);
        if (propVal.equals(defaultValue)) {
            properties.setProperty(key, defaultValue);
        }
        return propVal;
    }

    private static int getAndSetPropertyIfUndefined(Properties properties, String key, int defaultValue) throws ConfigurationException {
        int propVal = JmxScraperConfig.getProperty(properties, key, defaultValue);
        if (propVal == defaultValue) {
            properties.setProperty(key, String.valueOf(defaultValue));
        }
        return propVal;
    }

    private static void validateConfig(JmxScraperConfig config) throws ConfigurationException {
        if (StringUtils.isBlank(config.serviceUrl)) {
            throw new ConfigurationException("otel.jmx.service.url must be specified.");
        }
        if (StringUtils.isBlank(config.customJmxScrapingConfigPath) && config.targetSystems.isEmpty()) {
            throw new ConfigurationException("otel.jmx.custom.scraping.config or otel.jmx.target.system must be specified.");
        }
        if (!config.targetSystems.isEmpty() && !AVAILABLE_TARGET_SYSTEMS.containsAll(config.targetSystems)) {
            throw new ConfigurationException(String.format("%s must specify targets from %s", config.targetSystems, AVAILABLE_TARGET_SYSTEMS));
        }
        if (OTLP_METRICS_EXPORTER.equalsIgnoreCase(config.metricsExporterType) && StringUtils.isBlank(config.otlpExporterEndpoint)) {
            throw new ConfigurationException("otel.exporter.otlp.endpoint must be specified for otlp format.");
        }
        if (config.intervalMilliseconds < 0) {
            throw new ConfigurationException("otel.jmx.interval.milliseconds must be positive.");
        }
    }
}

