/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.yaml.JmxConfig;
import io.opentelemetry.instrumentation.jmx.yaml.JmxRule;
import io.opentelemetry.instrumentation.jmx.yaml.Metric;
import io.opentelemetry.instrumentation.jmx.yaml.MetricStructure;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

public class RuleParser {
    private static final Logger logger = Logger.getLogger(RuleParser.class.getName());
    private static final RuleParser theParser = new RuleParser();

    public static RuleParser get() {
        return theParser;
    }

    private RuleParser() {
    }

    public JmxConfig loadConfig(InputStream is) {
        LoadSettings settings = LoadSettings.builder().build();
        Load yaml = new Load(settings);
        Map data = (Map)yaml.loadFromInputStream(is);
        if (data == null) {
            return new JmxConfig(Collections.emptyList());
        }
        List rules = (List)data.remove("rules");
        if (rules == null) {
            return new JmxConfig(Collections.emptyList());
        }
        RuleParser.failOnExtraKeys(data);
        return new JmxConfig(rules.stream().map(obj -> (Map)obj).map(RuleParser::parseJmxRule).collect(Collectors.toList()));
    }

    private static JmxRule parseJmxRule(Map<String, Object> ruleYaml) {
        String prefix;
        List beans;
        JmxRule jmxRule = new JmxRule();
        String bean = (String)ruleYaml.remove("bean");
        if (bean != null) {
            jmxRule.setBean(bean);
        }
        if ((beans = (List)ruleYaml.remove("beans")) != null) {
            jmxRule.setBeans(beans);
        }
        if ((prefix = (String)ruleYaml.remove("prefix")) != null) {
            jmxRule.setPrefix(prefix);
        }
        jmxRule.setMapping(RuleParser.parseMappings((Map)ruleYaml.remove("mapping")));
        RuleParser.parseMetricStructure(ruleYaml, jmxRule);
        RuleParser.failOnExtraKeys(ruleYaml);
        return jmxRule;
    }

    private static Map<String, Metric> parseMappings(@Nullable Map<String, Object> mappingYaml) {
        LinkedHashMap<String, Metric> mappings = new LinkedHashMap<String, Metric>();
        if (mappingYaml != null) {
            mappingYaml.forEach((name, metricYaml) -> {
                Metric m = null;
                if (metricYaml != null) {
                    m = RuleParser.parseMetric((Map)metricYaml);
                }
                mappings.put((String)name, m);
            });
        }
        return mappings;
    }

    private static Metric parseMetric(Map<String, Object> metricYaml) {
        String desc;
        Metric metric = new Metric();
        String metricName = (String)metricYaml.remove("metric");
        if (metricName != null) {
            metric.setMetric(metricName);
        }
        if ((desc = (String)metricYaml.remove("desc")) != null) {
            metric.setDesc(desc);
        }
        RuleParser.parseMetricStructure(metricYaml, metric);
        RuleParser.failOnExtraKeys(metricYaml);
        return metric;
    }

    private static void parseMetricStructure(Map<String, Object> metricStructureYaml, MetricStructure out) {
        String unit;
        Map metricAttribute;
        String type = (String)metricStructureYaml.remove("type");
        if (type != null) {
            out.setType(type);
        }
        if ((metricAttribute = (Map)metricStructureYaml.remove("metricAttribute")) != null) {
            out.setMetricAttribute(metricAttribute);
        }
        if ((unit = (String)metricStructureYaml.remove("unit")) != null) {
            out.setUnit(unit);
        }
    }

    private static void failOnExtraKeys(Map<String, Object> yaml) {
        if (!yaml.isEmpty()) {
            throw new IllegalArgumentException("Unrecognized keys found: " + yaml.keySet());
        }
    }

    public void addMetricDefsTo(MetricConfiguration conf, InputStream is, String id) {
        try {
            JmxConfig config = this.loadConfig(is);
            logger.log(Level.INFO, "{0}: found {1} metric rules", new Object[]{id, config.getRules().size()});
            config.addMetricDefsTo(conf);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to parse YAML rules from {0}: {1}", new Object[]{id, RuleParser.rootCause(exception)});
            logger.log(Level.WARNING, exception.toString());
        }
    }

    private static String rootCause(Throwable exception) {
        String rootClass = "";
        String message = null;
        while (exception != null) {
            rootClass = exception.getClass().getSimpleName();
            message = exception.getMessage();
            exception = exception.getCause();
        }
        return message == null ? rootClass : message;
    }
}

