/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.instrumentation.jmx.engine.AttributeInfo;
import io.opentelemetry.instrumentation.jmx.engine.DetectionStatus;
import io.opentelemetry.instrumentation.jmx.engine.MetricAttribute;
import io.opentelemetry.instrumentation.jmx.engine.MetricExtractor;
import io.opentelemetry.instrumentation.jmx.engine.MetricInfo;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class MetricRegistrar {
    private static final Logger logger = Logger.getLogger(MetricRegistrar.class.getName());
    private final Meter meter;

    MetricRegistrar(OpenTelemetry openTelemetry, String instrumentationScope) {
        this.meter = openTelemetry.getMeter(instrumentationScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enrollExtractor(MBeanServerConnection connection, Collection<ObjectName> objectNames, MetricExtractor extractor, AttributeInfo attributeInfo) {
        boolean firstEnrollment;
        DetectionStatus status = new DetectionStatus(connection, objectNames);
        MetricExtractor metricExtractor = extractor;
        synchronized (metricExtractor) {
            firstEnrollment = extractor.getStatus() == null;
            extractor.setStatus(status);
        }
        if (!firstEnrollment) {
            return;
        }
        MetricInfo metricInfo = extractor.getInfo();
        String metricName = metricInfo.getMetricName();
        MetricInfo.Type instrumentType = metricInfo.getType();
        String description = metricInfo.getDescription() != null ? metricInfo.getDescription() : attributeInfo.getDescription();
        String unit = metricInfo.getUnit();
        switch (instrumentType) {
            case COUNTER: {
                LongCounterBuilder builder = this.meter.counterBuilder(metricName);
                Optional.ofNullable(description).ifPresent(builder::setDescription);
                Optional.ofNullable(unit).ifPresent(builder::setUnit);
                if (attributeInfo.usesDoubleValues()) {
                    builder.ofDoubles().buildWithCallback(MetricRegistrar.doubleTypeCallback(extractor));
                } else {
                    builder.buildWithCallback(MetricRegistrar.longTypeCallback(extractor));
                }
                logger.log(Level.INFO, "Created Counter for {0}", metricName);
                break;
            }
            case UPDOWNCOUNTER: {
                LongUpDownCounterBuilder builder = this.meter.upDownCounterBuilder(metricName);
                Optional.ofNullable(description).ifPresent(builder::setDescription);
                Optional.ofNullable(unit).ifPresent(builder::setUnit);
                if (attributeInfo.usesDoubleValues()) {
                    builder.ofDoubles().buildWithCallback(MetricRegistrar.doubleTypeCallback(extractor));
                } else {
                    builder.buildWithCallback(MetricRegistrar.longTypeCallback(extractor));
                }
                logger.log(Level.INFO, "Created UpDownCounter for {0}", metricName);
                break;
            }
            case GAUGE: {
                DoubleGaugeBuilder builder = this.meter.gaugeBuilder(metricName);
                Optional.ofNullable(description).ifPresent(builder::setDescription);
                Optional.ofNullable(unit).ifPresent(builder::setUnit);
                if (attributeInfo.usesDoubleValues()) {
                    builder.buildWithCallback(MetricRegistrar.doubleTypeCallback(extractor));
                } else {
                    builder.ofLongs().buildWithCallback(MetricRegistrar.longTypeCallback(extractor));
                }
                logger.log(Level.INFO, "Created Gauge for {0}", metricName);
                break;
            }
            case STATE: {
                throw new IllegalStateException("state metrics should not be registered");
            }
        }
    }

    static Consumer<ObservableDoubleMeasurement> doubleTypeCallback(MetricExtractor extractor) {
        return measurement -> {
            DetectionStatus status = extractor.getStatus();
            if (status != null) {
                MBeanServerConnection connection = status.getConnection();
                for (ObjectName objectName : status.getObjectNames()) {
                    Number metricValue = extractor.getMetricValueExtractor().extractNumericalAttribute(connection, objectName);
                    if (metricValue == null) continue;
                    Attributes attr = MetricRegistrar.createMetricAttributes(connection, objectName, extractor);
                    measurement.record(metricValue.doubleValue(), attr);
                }
            }
        };
    }

    static Consumer<ObservableLongMeasurement> longTypeCallback(MetricExtractor extractor) {
        return measurement -> {
            DetectionStatus status = extractor.getStatus();
            if (status != null) {
                MBeanServerConnection connection = status.getConnection();
                for (ObjectName objectName : status.getObjectNames()) {
                    Number metricValue = extractor.getMetricValueExtractor().extractNumericalAttribute(connection, objectName);
                    if (metricValue == null) continue;
                    Attributes attr = MetricRegistrar.createMetricAttributes(connection, objectName, extractor);
                    measurement.record(metricValue.longValue(), attr);
                }
            }
        };
    }

    static Attributes createMetricAttributes(MBeanServerConnection connection, ObjectName objectName, MetricExtractor extractor) {
        AttributesBuilder attrBuilder = Attributes.builder();
        for (MetricAttribute metricAttribute : extractor.getAttributes()) {
            String attributeValue = metricAttribute.acquireAttributeValue(connection, objectName);
            if (attributeValue == null) continue;
            attrBuilder = attrBuilder.put(metricAttribute.getAttributeName(), attributeValue);
        }
        return attrBuilder.build();
    }
}

