/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxscraper;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.contrib.jmxscraper.ArgumentsParsingException;
import io.opentelemetry.contrib.jmxscraper.JmxConnectorBuilder;
import io.opentelemetry.contrib.jmxscraper.config.ConfigurationException;
import io.opentelemetry.contrib.jmxscraper.config.JmxScraperConfig;
import io.opentelemetry.instrumentation.jmx.engine.JmxMetricInsight;
import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.yaml.RuleParser;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;

public class JmxScraper {
    private static final Logger logger = Logger.getLogger(JmxScraper.class.getName());
    private static final String CONFIG_ARG = "-config";
    private static final String OTEL_AUTOCONFIGURE = "otel.java.global-autoconfigure.enabled";
    private final JmxConnectorBuilder client;
    private final JmxMetricInsight service;
    private final JmxScraperConfig config;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public static void main(String[] args2) {
        if (System.getProperty(OTEL_AUTOCONFIGURE) == null) {
            System.setProperty(OTEL_AUTOCONFIGURE, "true");
        }
        try {
            JmxScraperConfig config = JmxScraperConfig.fromProperties(JmxScraper.parseArgs(Arrays.asList(args2)), System.getProperties());
            config.propagateSystemProperties();
            JmxMetricInsight service = JmxMetricInsight.createService(GlobalOpenTelemetry.get(), config.getIntervalMilliseconds());
            JmxConnectorBuilder connectorBuilder = JmxConnectorBuilder.createNew(config.getServiceUrl());
            Optional.ofNullable(config.getUsername()).ifPresent(connectorBuilder::withUser);
            Optional.ofNullable(config.getPassword()).ifPresent(connectorBuilder::withPassword);
            JmxScraper jmxScraper = new JmxScraper(connectorBuilder, service, config);
            jmxScraper.start();
        }
        catch (ArgumentsParsingException e) {
            System.err.println("ERROR: " + e.getMessage());
            System.err.println("Usage: java -jar <path_to_jmxscraper.jar> -config <path_to_config.properties or - for stdin>");
            System.exit(1);
        }
        catch (ConfigurationException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Unable to connect " + e.getMessage());
            System.exit(2);
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
            System.exit(3);
        }
    }

    static Properties parseArgs(List<String> args2) throws ArgumentsParsingException, ConfigurationException {
        if (args2.isEmpty()) {
            return new Properties();
        }
        if (args2.size() != 2) {
            throw new ArgumentsParsingException("Exactly two arguments expected, got " + args2.size());
        }
        if (!args2.get(0).equalsIgnoreCase(CONFIG_ARG)) {
            throw new ArgumentsParsingException("Unexpected first argument must be '-config'");
        }
        String path = args2.get(1);
        if (path.trim().equals("-")) {
            return JmxScraper.loadPropertiesFromStdin();
        }
        return JmxScraper.loadPropertiesFromPath(path);
    }

    private static Properties loadPropertiesFromStdin() throws ConfigurationException {
        Properties properties;
        Properties properties2 = new Properties();
        DataInputStream is = new DataInputStream(System.in);
        try {
            properties2.load(is);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to read config properties from stdin", e);
            }
        }
        ((InputStream)is).close();
        return properties;
    }

    private static Properties loadPropertiesFromPath(String path) throws ConfigurationException {
        Properties properties;
        block8: {
            Properties properties2 = new Properties();
            InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            try {
                properties2.load(is);
                properties = properties2;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigurationException("Failed to read config properties file: '" + path + "'", e);
                }
            }
            is.close();
        }
        return properties;
    }

    JmxScraper(JmxConnectorBuilder client, JmxMetricInsight service, JmxScraperConfig config) {
        this.client = client;
        this.service = service;
        this.config = config;
    }

    private void start() throws IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("JMX scraping stopped");
            this.running.set(false);
        }));
        try (JMXConnector connector = this.client.build();){
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            this.service.startRemote(JmxScraper.getMetricConfig(this.config), () -> Collections.singletonList(connection));
            this.running.set(true);
            logger.info("JMX scraping started");
            while (this.running.get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static MetricConfiguration getMetricConfig(JmxScraperConfig scraperConfig) {
        MetricConfiguration config = new MetricConfiguration();
        for (String system : scraperConfig.getTargetSystems()) {
            JmxScraper.addRulesForSystem(system, config);
        }
        return config;
    }

    private static void addRulesForSystem(String system, MetricConfiguration conf) {
        block9: {
            String yamlResource = system + ".yaml";
            try (InputStream inputStream2 = JmxScraper.class.getClassLoader().getResourceAsStream(yamlResource);){
                if (inputStream2 != null) {
                    RuleParser parserInstance = RuleParser.get();
                    parserInstance.addMetricDefsTo(conf, inputStream2, system);
                    break block9;
                }
                throw new IllegalArgumentException("No support for system" + system);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while loading rules for system " + system, e);
            }
        }
    }
}

