/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.trace.AutoValue_TestSpanData;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class TestSpanData
implements SpanData {
    public static Builder builder() {
        return new AutoValue_TestSpanData.Builder().setSpanContext(SpanContext.getInvalid()).setParentSpanContext(SpanContext.getInvalid()).setInstrumentationLibraryInfo(InstrumentationLibraryInfo.empty()).setLinks(Collections.emptyList()).setTotalRecordedLinks(0).setAttributes(Attributes.empty()).setEvents(Collections.emptyList()).setTotalRecordedEvents(0).setResource(Resource.empty()).setTotalAttributeCount(0);
    }

    TestSpanData() {
    }

    abstract boolean getInternalHasEnded();

    @Override
    public final boolean hasEnded() {
        return this.getInternalHasEnded();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract TestSpanData autoBuild();

        abstract List<EventData> getEvents();

        abstract List<LinkData> getLinks();

        public TestSpanData build() {
            this.setEvents(Collections.unmodifiableList(new ArrayList<EventData>(this.getEvents())));
            this.setLinks(Collections.unmodifiableList(new ArrayList<LinkData>(this.getLinks())));
            return this.autoBuild();
        }

        public abstract Builder setSpanContext(SpanContext var1);

        public abstract Builder setParentSpanContext(SpanContext var1);

        public abstract Builder setResource(Resource var1);

        public abstract Builder setInstrumentationLibraryInfo(InstrumentationLibraryInfo var1);

        public abstract Builder setName(String var1);

        public abstract Builder setStartEpochNanos(long var1);

        public abstract Builder setEndEpochNanos(long var1);

        public abstract Builder setAttributes(Attributes var1);

        public abstract Builder setEvents(List<EventData> var1);

        public abstract Builder setStatus(StatusData var1);

        public abstract Builder setKind(SpanKind var1);

        public abstract Builder setLinks(List<LinkData> var1);

        abstract Builder setInternalHasEnded(boolean var1);

        public final Builder setHasEnded(boolean hasEnded) {
            return this.setInternalHasEnded(hasEnded);
        }

        public abstract Builder setTotalRecordedEvents(int var1);

        public abstract Builder setTotalRecordedLinks(int var1);

        public abstract Builder setTotalAttributeCount(int var1);
    }
}

