/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Aggregation {
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(Aggregation.class.getName()));
    static final List<Double> DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES = Collections.unmodifiableList(Arrays.asList(5.0, 10.0, 25.0, 50.0, 75.0, 100.0, 250.0, 500.0, 750.0, 1000.0, 2500.0, 5000.0, 7500.0, 10000.0));
    private static final Aggregation NONE = Aggregation.make("none", unused -> null);
    private static final Aggregation DEFAULT = Aggregation.make("default", i -> {
        switch (i.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_SUM: 
            case OBSERVABLE_UP_DOWN_SUM: {
                return AggregatorFactory.sum(AggregationTemporality.CUMULATIVE);
            }
            case HISTOGRAM: {
                return AggregatorFactory.histogram(DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES, AggregationTemporality.CUMULATIVE);
            }
            case OBSERVABLE_GAUGE: {
                return AggregatorFactory.lastValue();
            }
        }
        logger.log(Level.WARNING, "Unable to find default aggregation for instrument: " + i);
        return null;
    });
    private static final Aggregation SUM = Aggregation.sum(AggregationTemporality.CUMULATIVE);
    private static final Aggregation LAST_VALUE = Aggregation.make("lastValue", unused -> AggregatorFactory.lastValue());
    private static final Aggregation EXPLICIT_BUCKET_HISTOGRAM = Aggregation.explictBucketHistogram(AggregationTemporality.CUMULATIVE, DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES);

    private Aggregation() {
    }

    public abstract AggregatorFactory config(InstrumentDescriptor var1);

    public static Aggregation none() {
        return NONE;
    }

    public static Aggregation defaultAggregation() {
        return DEFAULT;
    }

    public static Aggregation sum(AggregationTemporality temporality) {
        return Aggregation.make("sum", unused -> AggregatorFactory.sum(temporality));
    }

    public static Aggregation sum() {
        return SUM;
    }

    public static Aggregation lastValue() {
        return LAST_VALUE;
    }

    public static Aggregation explictBucketHistogram() {
        return EXPLICIT_BUCKET_HISTOGRAM;
    }

    public static Aggregation explictBucketHistogram(AggregationTemporality temporality) {
        return Aggregation.explictBucketHistogram(temporality, DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES);
    }

    public static Aggregation explictBucketHistogram(AggregationTemporality temporality, List<Double> bucketBoundaries) {
        return Aggregation.make("explicitBucketHistogram", unused -> AggregatorFactory.histogram(bucketBoundaries, temporality));
    }

    public static final Aggregation histogram() {
        return EXPLICIT_BUCKET_HISTOGRAM;
    }

    static Aggregation make(final String name, final Function<InstrumentDescriptor, AggregatorFactory> factory) {
        return new Aggregation(){

            @Override
            public AggregatorFactory config(InstrumentDescriptor instrument) {
                return (AggregatorFactory)factory.apply(instrument);
            }

            public String toString() {
                return name;
            }
        };
    }
}

