/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;

final class LastValueAggregatorFactory
implements AggregatorFactory {
    static final AggregatorFactory INSTANCE = new LastValueAggregatorFactory();

    private LastValueAggregatorFactory() {
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, MetricDescriptor metricDescriptor) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(resource, instrumentationLibraryInfo, metricDescriptor);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(resource, instrumentationLibraryInfo, metricDescriptor);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

