/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.MetricExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetryResourceAutoConfiguration;
import io.opentelemetry.sdk.autoconfigure.PropagatorConfiguration;
import io.opentelemetry.sdk.autoconfigure.TracerProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.SdkMeterProviderConfigurer;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.util.ServiceLoader;

public final class OpenTelemetrySdkAutoConfiguration {
    public static OpenTelemetrySdk initialize() {
        return OpenTelemetrySdkAutoConfiguration.initialize(true);
    }

    public static OpenTelemetrySdk initialize(boolean setResultAsGlobal) {
        return OpenTelemetrySdkAutoConfiguration.initialize(setResultAsGlobal, DefaultConfigProperties.get());
    }

    public static OpenTelemetrySdk initialize(boolean setResultAsGlobal, ConfigProperties config) {
        ContextPropagators propagators = PropagatorConfiguration.configurePropagators(config);
        Resource resource = OpenTelemetryResourceAutoConfiguration.configureResource(config);
        OpenTelemetrySdkAutoConfiguration.configureMeterProvider(resource, config);
        SdkTracerProvider tracerProvider = TracerProviderConfiguration.configureTracerProvider(resource, config);
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(propagators).build();
        if (setResultAsGlobal) {
            GlobalOpenTelemetry.set(openTelemetrySdk);
        }
        return openTelemetrySdk;
    }

    private static void configureMeterProvider(Resource resource, ConfigProperties config) {
        String exporterName = config.getString("otel.metrics.exporter");
        if (exporterName == null) {
            exporterName = "none";
        }
        if (exporterName.equals("none")) {
            return;
        }
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder().setResource(resource);
        for (SdkMeterProviderConfigurer configurer : ServiceLoader.load(SdkMeterProviderConfigurer.class)) {
            configurer.configure(meterProviderBuilder, config);
        }
        SdkMeterProvider meterProvider = meterProviderBuilder.buildAndRegisterGlobal();
        MetricExporterConfiguration.configureExporter(exporterName, config, meterProvider);
    }

    private OpenTelemetrySdkAutoConfiguration() {
    }
}

