/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxmetrics;

import javax.annotation.Nullable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;

public class ClientCallbackHandler
implements CallbackHandler {
    private final String username;
    @Nullable
    private final char[] password;
    private final String realm;

    public ClientCallbackHandler(String username, String password, String realm) {
        this.username = username;
        this.password = password != null ? password.toCharArray() : null;
        this.realm = realm;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password);
                continue;
            }
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText(this.realm);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

